/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.cloud.core.autoconfigure;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.Year;
import java.util.Date;
import java.util.Objects;
import net.guerlab.cloud.core.properties.NumberJsonStringFormatProperties;
import net.guerlab.cloud.core.util.SpringUtils;
import net.guerlab.commons.collection.CollectionUtil;
import net.guerlab.commons.time.jackson.deserializer.DateDeserializer;
import net.guerlab.commons.time.jackson.deserializer.LocalDateDeserializer;
import net.guerlab.commons.time.jackson.deserializer.LocalDateTimeDeserializer;
import net.guerlab.commons.time.jackson.deserializer.LocalTimeDeserializer;
import net.guerlab.commons.time.jackson.deserializer.MonthDeserializer;
import net.guerlab.commons.time.jackson.deserializer.YearDeserializer;
import net.guerlab.commons.time.jackson.serializer.DateSerializer;
import net.guerlab.commons.time.jackson.serializer.LocalDateSerializer;
import net.guerlab.commons.time.jackson.serializer.LocalDateTimeSerializer;
import net.guerlab.commons.time.jackson.serializer.LocalTimeSerializer;
import net.guerlab.commons.time.jackson.serializer.MonthSerializer;
import net.guerlab.commons.time.jackson.serializer.YearSerializer;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.lang.Nullable;

@Configuration
@EnableConfigurationProperties(value={NumberJsonStringFormatProperties.class})
public class ObjectMapperAutoconfigure {
    public static void setProperties(ObjectMapper objectMapper, NumberJsonStringFormatProperties properties) {
        SimpleModule module = new SimpleModule();
        module.addDeserializer(Date.class, (JsonDeserializer)new DateDeserializer());
        module.addDeserializer(LocalDate.class, (JsonDeserializer)new LocalDateDeserializer());
        module.addDeserializer(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer());
        module.addDeserializer(LocalTime.class, (JsonDeserializer)new LocalTimeDeserializer());
        module.addDeserializer(Month.class, (JsonDeserializer)new MonthDeserializer());
        module.addDeserializer(Year.class, (JsonDeserializer)new YearDeserializer());
        module.addSerializer(Date.class, (JsonSerializer)new DateSerializer());
        module.addSerializer(LocalDate.class, (JsonSerializer)new LocalDateSerializer());
        module.addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer());
        module.addSerializer(LocalTime.class, (JsonSerializer)new LocalTimeSerializer());
        module.addSerializer(Month.class, (JsonSerializer)new MonthSerializer());
        module.addSerializer(Year.class, (JsonSerializer)new YearSerializer());
        ObjectMapperAutoconfigure.moduleAdvice(module, properties);
        objectMapper.findAndRegisterModules();
        objectMapper.registerModule((Module)module);
    }

    private static void moduleAdvice(SimpleModule module, @Nullable NumberJsonStringFormatProperties properties) {
        if (properties == null) {
            return;
        }
        ToStringSerializer serializer = ToStringSerializer.instance;
        if (properties.isFormatAllNumber()) {
            module.addSerializer(Number.class, (JsonSerializer)serializer);
        }
        if (properties.isFormatBigDecimal()) {
            module.addSerializer(BigDecimal.class, (JsonSerializer)serializer);
        }
        if (properties.isFormatBigInteger()) {
            module.addSerializer(BigInteger.class, (JsonSerializer)serializer);
        }
        if (properties.isFormatByteClass()) {
            module.addSerializer(Byte.class, (JsonSerializer)serializer);
        }
        if (properties.isFormatByteType()) {
            module.addSerializer(Byte.TYPE, (JsonSerializer)serializer);
        }
        if (properties.isFormatDoubleClass()) {
            module.addSerializer(Double.class, (JsonSerializer)serializer);
        }
        if (properties.isFormatDoubleType()) {
            module.addSerializer(Double.TYPE, (JsonSerializer)serializer);
        }
        if (properties.isFormatFloatClass()) {
            module.addSerializer(Float.class, (JsonSerializer)serializer);
        }
        if (properties.isFormatFloatType()) {
            module.addSerializer(Float.TYPE, (JsonSerializer)serializer);
        }
        if (properties.isFormatIntegerClass()) {
            module.addSerializer(Integer.class, (JsonSerializer)serializer);
        }
        if (properties.isFormatIntegerType()) {
            module.addSerializer(Integer.TYPE, (JsonSerializer)serializer);
        }
        if (properties.isFormatLongClass()) {
            module.addSerializer(Long.class, (JsonSerializer)serializer);
        }
        if (properties.isFormatLongType()) {
            module.addSerializer(Long.TYPE, (JsonSerializer)serializer);
        }
        if (properties.isFormatShortClass()) {
            module.addSerializer(Short.class, (JsonSerializer)serializer);
        }
        if (properties.isFormatShortType()) {
            module.addSerializer(Short.TYPE, (JsonSerializer)serializer);
        }
        if (CollectionUtil.isNotEmpty(properties.getFormatNumberClassList())) {
            properties.getFormatNumberClassList().stream().filter(Objects::nonNull).forEach(clazz -> module.addSerializer(clazz, (JsonSerializer)serializer));
        }
    }

    public static void setProperties(ObjectMapper objectMapper) {
        ObjectMapperAutoconfigure.setProperties(objectMapper, SpringUtils.getBean(NumberJsonStringFormatProperties.class));
    }

    @Autowired
    public void objectMapperAdvice(ObjectProvider<ObjectMapper> objectMapperProvider, NumberJsonStringFormatProperties properties) {
        objectMapperProvider.ifAvailable(objectMapper -> ObjectMapperAutoconfigure.setProperties(objectMapper, properties));
    }
}

