/*
 * Decompiled with CFR 0.152.
 */
package net.gpedro.integrations.slack;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlackField {
    private static final String TITLE = "title";
    private static final String VALUE = "value";
    private static final String SHORT = "short";
    private static final String MRKDWN_IN = "mrkdwn_in";
    private static final String FIELD_ALLOWS_MARKDOWN_REGEX = "^(pretext|text|title|fields|fallback)$";
    private List<String> allowMarkdown = null;
    private boolean shorten = false;
    private String title = null;
    private String value = null;

    public void addAllowedMarkdown(String field) {
        if (this.allowMarkdown == null) {
            this.allowMarkdown = new ArrayList<String>();
        }
        if (!field.matches(FIELD_ALLOWS_MARKDOWN_REGEX)) {
            throw new IllegalArgumentException(field + " is not allowed. Allowed: pretext, text, title, fields and fallback");
        }
        this.allowMarkdown.add(field);
    }

    public boolean isShorten() {
        return this.shorten;
    }

    private JsonArray prepareMarkdown() {
        JsonArray data = new JsonArray();
        for (String item : this.allowMarkdown) {
            data.add((JsonElement)new JsonPrimitive(item));
        }
        return data;
    }

    public void setAllowedMarkdown(ArrayList<String> allowMarkdown) {
        if (allowMarkdown != null) {
            this.allowMarkdown = allowMarkdown;
        }
    }

    public SlackField setShorten(boolean shorten) {
        this.shorten = shorten;
        return this;
    }

    public SlackField setTitle(String title) {
        this.title = title;
        return this;
    }

    public SlackField setValue(String value) {
        this.value = value;
        return this;
    }

    public JsonObject toJson() {
        JsonObject data = new JsonObject();
        data.addProperty(TITLE, this.title);
        data.addProperty(VALUE, this.value);
        data.addProperty(SHORT, Boolean.valueOf(this.shorten));
        if (this.allowMarkdown != null && this.allowMarkdown.size() > 0) {
            data.add(MRKDWN_IN, (JsonElement)this.prepareMarkdown());
        }
        return data;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SlackField that = (SlackField)o;
        if (this.shorten != that.shorten) {
            return false;
        }
        if (this.allowMarkdown != null ? !this.allowMarkdown.equals(that.allowMarkdown) : that.allowMarkdown != null) {
            return false;
        }
        if (this.title != null ? !this.title.equals(that.title) : that.title != null) {
            return false;
        }
        return !(this.value == null ? that.value != null : !this.value.equals(that.value));
    }

    public int hashCode() {
        int result = this.allowMarkdown != null ? this.allowMarkdown.hashCode() : 0;
        result = 31 * result + (this.shorten ? 1 : 0);
        result = 31 * result + (this.title != null ? this.title.hashCode() : 0);
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "SlackField{allowMarkdown=" + this.allowMarkdown + ", shorten=" + this.shorten + ", title='" + this.title + '\'' + ", value='" + this.value + '\'' + '}';
    }
}

