/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.model;

import java.io.Serializable;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.text.DecimalFormat;
import net.bull.javamelody.internal.common.I18N;
import net.bull.javamelody.internal.model.MBeansAccessor;

public class MemoryInformations
implements Serializable {
    private static final long serialVersionUID = 3281861236369720876L;
    private static final String NEXT = ",\n";
    private static final String MO = " Mo";
    private final long usedMemory = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    private final long maxMemory = Runtime.getRuntime().maxMemory();
    private final long usedPermGen;
    private final long maxPermGen;
    private final long usedNonHeapMemory;
    private final long usedBufferedMemory;
    private final int loadedClassesCount;
    private final long garbageCollectionTimeMillis;
    private final long usedPhysicalMemorySize;
    private final long usedSwapSpaceSize;
    private final String memoryDetails;

    MemoryInformations() {
        MemoryPoolMXBean permGenMemoryPool = MemoryInformations.getPermGenMemoryPool();
        if (permGenMemoryPool != null) {
            MemoryUsage usage = permGenMemoryPool.getUsage();
            this.usedPermGen = usage.getUsed();
            this.maxPermGen = usage.getMax();
        } else {
            this.usedPermGen = -1L;
            this.maxPermGen = -1L;
        }
        this.usedNonHeapMemory = ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage().getUsed();
        this.usedBufferedMemory = MBeansAccessor.getUsedBufferMemory();
        this.loadedClassesCount = ManagementFactory.getClassLoadingMXBean().getLoadedClassCount();
        this.garbageCollectionTimeMillis = MemoryInformations.buildGarbageCollectionTimeMillis();
        this.usedPhysicalMemorySize = MBeansAccessor.getLongFromOperatingSystem("TotalPhysicalMemorySize") - MBeansAccessor.getLongFromOperatingSystem("FreePhysicalMemorySize");
        this.usedSwapSpaceSize = this.buildUsedSwapSpaceSize();
        this.memoryDetails = this.buildMemoryDetails();
    }

    private long buildUsedSwapSpaceSize() {
        try {
            return MBeansAccessor.getLongFromOperatingSystem("TotalSwapSpaceSize") - MBeansAccessor.getLongFromOperatingSystem("FreeSwapSpaceSize");
        }
        catch (Throwable e) {
            return -1L;
        }
    }

    private static MemoryPoolMXBean getPermGenMemoryPool() {
        for (MemoryPoolMXBean memoryPool : ManagementFactory.getMemoryPoolMXBeans()) {
            if (!memoryPool.getName().endsWith("Perm Gen")) continue;
            return memoryPool;
        }
        return null;
    }

    private static long buildGarbageCollectionTimeMillis() {
        long garbageCollectionTime = 0L;
        for (GarbageCollectorMXBean garbageCollector : ManagementFactory.getGarbageCollectorMXBeans()) {
            garbageCollectionTime += garbageCollector.getCollectionTime();
        }
        return garbageCollectionTime;
    }

    private String buildMemoryDetails() {
        DecimalFormat integerFormat = I18N.createIntegerFormat();
        String nonHeapMemory = "Non heap memory = " + integerFormat.format(this.usedNonHeapMemory / 1024L / 1024L) + MO + " (Perm Gen, Code Cache)";
        String classLoading = "Loaded classes = " + integerFormat.format(this.loadedClassesCount);
        String gc = "Garbage collection time = " + integerFormat.format(this.garbageCollectionTimeMillis) + " ms";
        String osInfo = "";
        String osInfo2 = "";
        long totalPhysicalMemorySize = MBeansAccessor.getLongFromOperatingSystem("TotalPhysicalMemorySize");
        if (totalPhysicalMemorySize >= 0L) {
            osInfo = "Process cpu time = " + integerFormat.format(MBeansAccessor.getLongFromOperatingSystem("ProcessCpuTime") / 1000000L) + " ms,\nCommitted virtual memory = " + integerFormat.format(MBeansAccessor.getLongFromOperatingSystem("CommittedVirtualMemorySize") / 1024L / 1024L) + MO + ",\nFree physical memory = " + integerFormat.format(MBeansAccessor.getLongFromOperatingSystem("FreePhysicalMemorySize") / 1024L / 1024L) + MO + ",\nTotal physical memory = " + integerFormat.format(totalPhysicalMemorySize / 1024L / 1024L) + MO;
            try {
                osInfo2 = ",\nFree swap space = " + integerFormat.format(MBeansAccessor.getLongFromOperatingSystem("FreeSwapSpaceSize") / 1024L / 1024L) + MO + ",\nTotal swap space = " + integerFormat.format(MBeansAccessor.getLongFromOperatingSystem("TotalSwapSpaceSize") / 1024L / 1024L) + MO;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.usedBufferedMemory < 0L) {
            return nonHeapMemory + NEXT + classLoading + NEXT + gc + NEXT + osInfo + osInfo2;
        }
        String bufferedMemory = "Buffered memory = " + integerFormat.format(this.usedBufferedMemory / 1024L / 1024L) + MO;
        return nonHeapMemory + NEXT + bufferedMemory + NEXT + classLoading + NEXT + gc + NEXT + osInfo;
    }

    public long getUsedMemory() {
        return this.usedMemory;
    }

    public long getMaxMemory() {
        return this.maxMemory;
    }

    public double getUsedMemoryPercentage() {
        return 100.0 * (double)this.usedMemory / (double)this.maxMemory;
    }

    public long getUsedPermGen() {
        return this.usedPermGen;
    }

    public long getMaxPermGen() {
        return this.maxPermGen;
    }

    public double getUsedPermGenPercentage() {
        if (this.usedPermGen > 0L && this.maxPermGen > 0L) {
            return 100.0 * (double)this.usedPermGen / (double)this.maxPermGen;
        }
        return -1.0;
    }

    public long getUsedNonHeapMemory() {
        return this.usedNonHeapMemory;
    }

    public long getUsedBufferedMemory() {
        return this.usedBufferedMemory;
    }

    public int getLoadedClassesCount() {
        return this.loadedClassesCount;
    }

    public long getGarbageCollectionTimeMillis() {
        return this.garbageCollectionTimeMillis;
    }

    public long getUsedPhysicalMemorySize() {
        return this.usedPhysicalMemorySize;
    }

    public long getUsedSwapSpaceSize() {
        return this.usedSwapSpaceSize;
    }

    public String getMemoryDetails() {
        return this.memoryDetails;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[usedMemory=" + this.getUsedMemory() + ", maxMemory=" + this.getMaxMemory() + ']';
    }
}

