/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import jakarta.servlet.ServletContext;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.JspWriter;
import jakarta.servlet.jsp.tagext.TagSupport;
import java.io.IOException;
import net.bull.javamelody.FilterContext;
import net.bull.javamelody.internal.model.Collector;
import net.bull.javamelody.internal.model.Counter;
import net.bull.javamelody.internal.model.CounterRequest;

public class PrometheusCounterRequestTag
extends TagSupport {
    private static final long serialVersionUID = 1L;
    private String requestId;
    private String metricHelp;

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public String getMetricHelp() {
        return this.metricHelp;
    }

    public void setMetricHelp(String metricHelp) {
        this.metricHelp = metricHelp;
        if (this.metricHelp != null) {
            this.metricHelp = this.metricHelp.trim().replace('\n', ' ').replace('\r', ' ');
        }
    }

    public int doEndTag() throws JspException {
        ServletContext servletContext = this.pageContext.getServletContext();
        FilterContext filterContext = (FilterContext)servletContext.getAttribute("javamelody.filterContext");
        Collector collector = filterContext.getCollector();
        for (Counter counter : collector.getCounters()) {
            if (!counter.isDisplayed() || !counter.isRequestIdFromThisCounter(this.requestId)) continue;
            CounterRequest counterRequest = counter.getCounterRequestById(this.requestId);
            try {
                this.printRequest(counter, counterRequest);
            }
            catch (IOException e) {
                throw new JspException((Throwable)e);
            }
            return super.doStartTag();
        }
        throw new IllegalArgumentException("Request not found : " + this.requestId);
    }

    private void printRequest(Counter counter, CounterRequest counterRequest) throws IOException {
        long hits = counterRequest.getHits();
        long errors = counterRequest.getSystemErrors();
        long duration = counterRequest.getDurationsSum();
        if (this.metricHelp != null) {
            this.println("# HELP ", this.requestId, "_hits_count ", this.metricHelp);
        }
        this.println("# TYPE ", this.requestId, "_hits_count counter");
        this.println(this.requestId, "_hits_count ", String.valueOf(hits));
        if (!counter.isErrorCounter() || counter.isJobCounter()) {
            if (this.metricHelp != null) {
                this.println("# HELP ", this.requestId, "_errors_count ", this.metricHelp);
            }
            this.println("# TYPE ", this.requestId, "_errors_count counter");
            this.println(this.requestId, "_errors_count ", String.valueOf(errors));
        }
        if (duration >= 0L) {
            if (this.metricHelp != null) {
                this.println("# HELP ", this.requestId, "_duration_millis ", this.metricHelp);
            }
            this.println("# TYPE ", this.requestId, "_duration_millis counter");
            this.println(this.requestId, "_duration_millis ", String.valueOf(duration));
        }
    }

    private void println(String ... strings) throws IOException {
        JspWriter out = this.pageContext.getOut();
        for (String s : strings) {
            out.print(s);
        }
        out.print('\n');
    }
}

