/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.util;

import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LocaleUtils {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$myfaces$util$LocaleUtils == null ? (class$org$apache$myfaces$util$LocaleUtils = LocaleUtils.class$("org.apache.myfaces.util.LocaleUtils")) : class$org$apache$myfaces$util$LocaleUtils));
    static /* synthetic */ Class class$org$apache$myfaces$util$LocaleUtils;

    private LocaleUtils() {
    }

    public static Locale toLocale(String localeString) {
        String country;
        String variant;
        String language;
        int separator;
        if (localeString == null || localeString.length() == 0) {
            log.error((Object)"Locale name null or empty, ignoring");
            return Locale.getDefault();
        }
        int separatorCountry = localeString.indexOf(95);
        if (separatorCountry >= 0) {
            separator = 95;
        } else {
            separatorCountry = localeString.indexOf(45);
            separator = 45;
        }
        if (separatorCountry < 0) {
            language = localeString;
            variant = "";
            country = "";
        } else {
            language = localeString.substring(0, separatorCountry);
            int separatorVariant = localeString.indexOf(separator, separatorCountry + 1);
            if (separatorVariant < 0) {
                country = localeString.substring(separatorCountry + 1);
                variant = "";
            } else {
                country = localeString.substring(separatorCountry + 1, separatorVariant);
                variant = localeString.substring(separatorVariant + 1);
            }
        }
        return new Locale(language, country, variant);
    }

    public static Locale converterTagLocaleFromString(String name) {
        try {
            Locale locale;
            StringTokenizer st = new StringTokenizer(name, "_");
            String language = st.nextToken();
            String country = st.nextToken();
            if (st.hasMoreTokens()) {
                String variant = st.nextToken();
                locale = new Locale(language, country, variant);
            } else {
                locale = new Locale(language, country);
            }
            return locale;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Locale parsing exception - invalid string representation '" + name + "'");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

