/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.tree2;

import java.util.Map;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlCommandLink;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import javax.faces.event.ActionEvent;
import org.apache.myfaces.custom.tree2.TreeNode;
import org.apache.myfaces.custom.tree2.UITreeData;

public class HtmlTree
extends UITreeData {
    public static final String COMPONENT_TYPE = "org.apache.myfaces.HtmlTree2";
    private static final String DEFAULT_RENDERER_TYPE = "org.apache.myfaces.HtmlTree2";
    private static final String NODE_STATE_KEY = "org.apache.myfaces.tree.NODE_STATE_KEY";
    private UICommand _expandControl;
    private String _varNodeToggler;
    private String _selectedNodeId;

    public HtmlTree() {
        this.setRendererType("org.apache.myfaces.HtmlTree2");
        this._expandControl = new HtmlCommandLink();
        this._expandControl.setParent((UIComponent)this);
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this._varNodeToggler, this._selectedNodeId};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.setVarNodeToggler((String)values[1]);
        this._selectedNodeId = (String)values[2];
    }

    public void setNodeId(String nodeId) {
        super.setNodeId(nodeId);
        if (this._varNodeToggler != null) {
            Map requestMap = this.getFacesContext().getExternalContext().getRequestMap();
            requestMap.put(this._varNodeToggler, this);
        }
    }

    public UICommand getExpandControl() {
        return this._expandControl;
    }

    public void setVarNodeToggler(String varNodeToggler) {
        this._varNodeToggler = varNodeToggler;
        String bindingString = "#{" + varNodeToggler + ".toggleExpanded}";
        MethodBinding actionBinding = FacesContext.getCurrentInstance().getApplication().createMethodBinding(bindingString, null);
        this._expandControl.setAction(actionBinding);
    }

    protected void processChildNodes(FacesContext context, TreeNode parentNode, int processAction) {
        super.processChildNodes(context, parentNode, processAction);
    }

    public void setNodeSelected(ActionEvent event) {
        this._selectedNodeId = this.getNodeId();
    }

    public boolean isNodeSelected() {
        return this.getNodeId() != null ? this.getNodeId().equals(this._selectedNodeId) : false;
    }
}

