/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.fileupload;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.ConverterException;
import javax.faces.render.Renderer;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.component.UserRoleUtils;
import org.apache.myfaces.component.html.util.MultipartRequestWrapper;
import org.apache.myfaces.custom.fileupload.HtmlInputFileUpload;
import org.apache.myfaces.custom.fileupload.UploadedFile;
import org.apache.myfaces.custom.fileupload.UploadedFileDefaultFileImpl;
import org.apache.myfaces.custom.fileupload.UploadedFileDefaultImplBase;
import org.apache.myfaces.custom.fileupload.UploadedFileDefaultMemoryImpl;
import org.apache.myfaces.renderkit.RendererUtils;
import org.apache.myfaces.renderkit.html.HTML;
import org.apache.myfaces.renderkit.html.HtmlRendererUtils;

public class HtmlFileUploadRenderer
extends Renderer {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$myfaces$custom$fileupload$HtmlFileUploadRenderer == null ? (class$org$apache$myfaces$custom$fileupload$HtmlFileUploadRenderer = HtmlFileUploadRenderer.class$("org.apache.myfaces.custom.fileupload.HtmlFileUploadRenderer")) : class$org$apache$myfaces$custom$fileupload$HtmlFileUploadRenderer));
    static /* synthetic */ Class class$org$apache$myfaces$custom$fileupload$HtmlFileUploadRenderer;

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        super.encodeEnd(facesContext, uiComponent);
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("input", uiComponent);
        writer.writeAttribute("type", (Object)"file", null);
        String clientId = uiComponent.getClientId(facesContext);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("name", (Object)clientId, null);
        UploadedFile value = (UploadedFile)((HtmlInputFileUpload)uiComponent).getValue();
        if (value != null && value.getName() != null) {
            writer.writeAttribute("value", (Object)value.getName(), null);
        }
        HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.INPUT_FILE_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED);
        if (this.isDisabled(facesContext, uiComponent)) {
            writer.writeAttribute("disabled", (Object)Boolean.TRUE, null);
        }
        writer.endElement("input");
    }

    protected boolean isDisabled(FacesContext facesContext, UIComponent uiComponent) {
        if (!UserRoleUtils.isEnabledOnUserRole(uiComponent)) {
            return false;
        }
        if (uiComponent instanceof HtmlInputFileUpload) {
            return ((HtmlInputFileUpload)uiComponent).isDisabled();
        }
        return RendererUtils.getBooleanAttribute(uiComponent, "disabled", false);
    }

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        super.decode(facesContext, uiComponent);
        if (facesContext.getExternalContext().getRequest() instanceof ServletRequest) {
            String paramName;
            MultipartRequestWrapper mpReq;
            FileItem fileItem;
            ServletRequest multipartRequest = (ServletRequest)facesContext.getExternalContext().getRequest();
            while (multipartRequest != null && !(multipartRequest instanceof MultipartRequestWrapper)) {
                if (multipartRequest instanceof HttpServletRequestWrapper) {
                    multipartRequest = ((HttpServletRequestWrapper)multipartRequest).getRequest();
                    continue;
                }
                multipartRequest = null;
            }
            if (multipartRequest != null && (fileItem = (mpReq = (MultipartRequestWrapper)multipartRequest).getFileItem(paramName = uiComponent.getClientId(facesContext))) != null) {
                try {
                    String implementation = ((HtmlInputFileUpload)uiComponent).getStorage();
                    UploadedFileDefaultImplBase upFile = implementation == null || "memory".equals(implementation) ? new UploadedFileDefaultMemoryImpl(fileItem) : new UploadedFileDefaultFileImpl(fileItem);
                    ((HtmlInputFileUpload)uiComponent).setSubmittedValue(upFile);
                    ((HtmlInputFileUpload)uiComponent).setValid(true);
                }
                catch (IOException ioe) {
                    log.error((Object)ioe);
                }
            }
        }
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        UploadedFile file;
        if (submittedValue instanceof UploadedFile && (file = (UploadedFile)submittedValue).getName() != null && file.getName().length() > 0) {
            return file;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

