/*
 * Decompiled with CFR 0.152.
 */
package middlegen.plugins.entitybean.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import middlegen.Table;
import middlegen.plugins.entitybean.Entity20Table;
import middlegen.swing.BooleanNodeCheckBox;
import middlegen.swing.JTableSettingsPanel;

public class JEntityTableSettingsPanel
extends JTableSettingsPanel {
    ActionListener _pkListener = new ActionListener(){

        public void actionPerformed(ActionEvent evt) {
            JEntityTableSettingsPanel.this._currentTable.setGeneratePkClass(JEntityTableSettingsPanel.this._primaryKeyTypeComboBox.getSelectedIndex() == 0);
        }
    };
    private final JLabel _ejbNameLabel = new JLabel("Logical EJB name");
    private final JTextField _ejbNameField = new JTextField();
    private final JLabel _viewTypeLabel = new JLabel("View type");
    private final BooleanNodeCheckBox _localCheckBox = new BooleanNodeCheckBox("Local", null);
    private final BooleanNodeCheckBox _remoteCheckBox = new BooleanNodeCheckBox("Remote", null);
    private final JLabel _primaryKeyTypeLabel = new JLabel("Primary key class");
    private final DefaultComboBoxModel _primaryKeyComboModel = new DefaultComboBoxModel();
    private final JComboBox _primaryKeyTypeComboBox = new JComboBox(this._primaryKeyComboModel);
    private final DocumentListener _documentListener = new DocumentListener(){

        public void changedUpdate(DocumentEvent event) {
            this.update();
        }

        public void insertUpdate(DocumentEvent event) {
            this.update();
        }

        public void removeUpdate(DocumentEvent event) {
            this.update();
        }

        private void update() {
            JEntityTableSettingsPanel.this.updateTable(JEntityTableSettingsPanel.this._ejbNameField.getText());
        }
    };
    private Entity20Table _currentTable;

    public JEntityTableSettingsPanel() {
        GridLayout layout = new GridLayout(0, 2, 4, 8);
        this.setLayout(layout);
        this.add(this._ejbNameLabel);
        this.add(this._ejbNameField);
        this.add(this._primaryKeyTypeLabel);
        this.add(this._primaryKeyTypeComboBox);
        this.add(this._viewTypeLabel);
        JPanel getterPanel = new JPanel();
        getterPanel.add((Component)this._localCheckBox);
        getterPanel.add((Component)this._remoteCheckBox);
        this.add(getterPanel);
        this._ejbNameField.getDocument().addDocumentListener(this._documentListener);
    }

    public void setTable(Table table) {
        this._currentTable = (Entity20Table)table;
        this._ejbNameField.setText(this._currentTable.getBeanName());
        this._remoteCheckBox.setBooleanNode(this._currentTable.getRemote());
        this._localCheckBox.setBooleanNode(this._currentTable.getLocal());
        this._primaryKeyTypeComboBox.removeActionListener(this._pkListener);
        this._primaryKeyComboModel.removeAllElements();
        this._primaryKeyComboModel.addElement(this._currentTable.getGeneratedPkClassName());
        String simplePkClassName = this._currentTable.getSimplePkClassName();
        if (simplePkClassName != null) {
            this._primaryKeyComboModel.addElement(simplePkClassName);
        }
        this._primaryKeyTypeComboBox.setSelectedItem(this._currentTable.getPkClassName());
        this._primaryKeyTypeComboBox.addActionListener(this._pkListener);
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    private void updateTable(String beanName) {
        this._currentTable.setBeanName(beanName);
    }
}

