/*
 * Decompiled with CFR 0.152.
 */
package middlegen.plugins.entitybean.swing;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import middlegen.Column;
import middlegen.Util;
import middlegen.javax.Sql2Java;
import middlegen.plugins.entitybean.Entity11Column;
import middlegen.swing.BooleanNodeCheckBox;
import middlegen.swing.JColumnSettingsPanel;

public class JEntity11ColumnSettingsPanel
extends JColumnSettingsPanel {
    protected JLabel _columnNameLabel;
    protected JTextField _columnNameField;
    protected JLabel _columnTypeLabel;
    protected JComboBox _columnTypeCombo;
    protected JLabel _setterLabel;
    protected BooleanNodeCheckBox _remoteSetterCheckBox;
    protected JLabel _getterLabel;
    protected BooleanNodeCheckBox _remoteGetterCheckBox;
    protected Entity11Column[] _currentColumns;
    private final DocumentListener _documentListener = new DocumentListener(){

        public void changedUpdate(DocumentEvent event) {
            this.update();
        }

        public void insertUpdate(DocumentEvent event) {
            this.update();
        }

        public void removeUpdate(DocumentEvent event) {
            this.update();
        }

        private void update() {
            if (JEntity11ColumnSettingsPanel.this._currentColumns.length > 0) {
                JEntity11ColumnSettingsPanel.this.updateColumn(JEntity11ColumnSettingsPanel.this._columnNameField.getText(), JEntity11ColumnSettingsPanel.this._currentColumns[0].getJavaType());
            }
        }
    };
    private final ActionListener _comboListener = new ActionListener(){

        public void actionPerformed(ActionEvent event) {
            this.update();
        }

        private void update() {
            for (int i = 0; i < JEntity11ColumnSettingsPanel.this._currentColumns.length; ++i) {
                String type = (String)JEntity11ColumnSettingsPanel.this._columnTypeCombo.getSelectedItem();
                if (type == null) continue;
                JEntity11ColumnSettingsPanel.this.updateColumn(JEntity11ColumnSettingsPanel.this._currentColumns[i].getVariableName(), type);
            }
        }
    };

    public JEntity11ColumnSettingsPanel() {
        GridLayout layout = new GridLayout(0, 2);
        this.setLayout(layout);
        this.initComponents();
        this.addComponents();
        this._columnNameField.getDocument().addDocumentListener(this._documentListener);
        this._columnTypeCombo.addActionListener(this._comboListener);
    }

    public void setColumns(Column[] columns) {
        this._currentColumns = new Entity11Column[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            this._currentColumns[i] = (Entity11Column)columns[i];
        }
        if (this._currentColumns.length == 1) {
            this._columnNameField.setText(this._currentColumns[0].getVariableName());
            this._columnNameField.setEnabled(true);
            this._remoteSetterCheckBox.setBooleanNode(this._currentColumns[0].getRemoteSet());
            this._remoteGetterCheckBox.setBooleanNode(this._currentColumns[0].getRemoteGet());
        } else {
            this._columnNameField.setText("");
            this._columnNameField.setEnabled(false);
            this._setterLabel.setText("setters");
            this._getterLabel.setText("getters");
        }
        String selectedJavaType = this._currentColumns[0].getJavaType();
        Object[][] arrays = new Object[this._currentColumns.length][];
        for (int i = 0; i < this._currentColumns.length; ++i) {
            arrays[i] = Sql2Java.getJavaTypes((int)this._currentColumns[i].getSqlType());
            String javaType = this._currentColumns[i].getJavaType();
            if (javaType.equals(selectedJavaType)) continue;
            selectedJavaType = "";
        }
        Object[] common = this.common(arrays);
        DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>(common);
        this._columnTypeCombo.setModel(model);
        this._columnTypeCombo.setSelectedItem(selectedJavaType);
    }

    protected void initComponents() {
        this._columnNameLabel = new JLabel("Java property name");
        this._columnNameField = new JTextField();
        this._columnTypeLabel = new JLabel("Java type");
        this._columnTypeCombo = new JComboBox();
        this._setterLabel = new JLabel("set XXX");
        this._remoteSetterCheckBox = new BooleanNodeCheckBox("Remote", null);
        this._getterLabel = new JLabel("get XXX");
        this._remoteGetterCheckBox = new BooleanNodeCheckBox("Remote", null);
    }

    protected void addComponents() {
        GridLayout layout = new GridLayout(0, 2, 4, 8);
        this.setLayout(layout);
        this.add(this._columnNameLabel);
        this.add(this._columnNameField);
        this.add(this._columnTypeLabel);
        this.add(this._columnTypeCombo);
        this.add(this._setterLabel);
        JPanel setterPanel = new JPanel();
        setterPanel.add((Component)this._remoteSetterCheckBox);
        this.add(setterPanel);
        this.add(this._getterLabel);
        JPanel getterPanel = new JPanel();
        getterPanel.add((Component)this._remoteGetterCheckBox);
        this.add(getterPanel);
    }

    private Object[] common(Object[][] arrays) {
        Integer occurrances;
        HashMap<Object, Integer> union = new HashMap<Object, Integer>();
        for (int i = 0; i < arrays.length; ++i) {
            Object[] array = arrays[i];
            for (int j = 0; j < array.length; ++j) {
                occurrances = (Integer)union.get(array[j]);
                if (occurrances == null) {
                    occurrances = new Integer(0);
                }
                union.put(array[j], new Integer(occurrances + 1));
            }
        }
        ArrayList<String> common = new ArrayList<String>();
        if (arrays.length > 1) {
            common.add("");
        }
        Iterator iterator = union.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            occurrances = (Integer)entry.getValue();
            if (occurrances != arrays.length) continue;
            common.add((String)entry.getKey());
        }
        Object[] result = common.toArray();
        Arrays.sort(result, Sql2Java.getTypeComparator());
        return result;
    }

    private void updateColumn(String propertyName, String javaType) {
        for (int i = 0; i < this._currentColumns.length; ++i) {
            this._currentColumns[i].setJavaType(javaType);
        }
        if (this._currentColumns.length == 1) {
            this._currentColumns[0].setVariableName(propertyName);
            String setter = "public void set" + Util.capitalise((String)this._currentColumns[0].getVariableName()) + "(" + this._currentColumns[0].getJavaType() + " " + this._currentColumns[0].getVariableName() + ")";
            this._setterLabel.setText(setter);
            String getter = "public " + this._currentColumns[0].getJavaType() + " get" + Util.capitalise((String)this._currentColumns[0].getVariableName()) + "()";
            this._getterLabel.setText(getter);
        }
    }
}

