/*
 * Decompiled with CFR 0.152.
 */
package middlegen.plugins.entitybean;

import java.util.ArrayList;
import java.util.Iterator;
import middlegen.FileProducer;
import middlegen.MiddlegenException;
import middlegen.javax.JavaPlugin;
import middlegen.plugins.entitybean.JBoss;
import middlegen.plugins.entitybean.JOnAS;
import middlegen.plugins.entitybean.MVCSoft;
import middlegen.plugins.entitybean.OracleSequence;
import middlegen.plugins.entitybean.SequenceBlock;
import middlegen.plugins.entitybean.Server;
import middlegen.plugins.entitybean.Weblogic;
import middlegen.predicate.PredicateFactory;
import middlegen.predicate.ant.DynamicPredicate;
import middlegen.predicates.column.ColumnPredicateFactory;
import middlegen.predicates.column.NotKey;
import middlegen.util.BooleanNode;
import org.apache.commons.collections.Predicate;
import org.apache.log4j.Category;

public abstract class Entity11Plugin
extends JavaPlugin {
    private final ArrayList _servers = new ArrayList();
    private Weblogic _weblogic;
    private JBoss _jboss;
    private JOnAS _jonas;
    private MVCSoft _mvcsoft;
    private SequenceBlock _sequenceBlock;
    private String _beansuffix = "Bean";
    private String _remotesuffix = "Remote";
    private String _remotehomesuffix = "Home";
    private String _datasuffix = "Data";
    private String _pksuffix = "PK";
    private String _pkpattern = null;
    private String _utilsuffix = "Util";
    private String _interfacePackage;
    private final BooleanNode _isRemote = BooleanNode.createRoot((boolean)false);
    private String _jndiPrefix;
    private boolean _pkClass = false;
    private boolean _dataobject = false;
    private boolean _valueobject = false;
    private boolean _sessionFacade = false;
    private boolean _isReadonly = false;
    private DynamicPredicate _finders = null;
    private boolean _guid = false;
    private OracleSequence _oracleSequence;
    private String _beanBaseClass = null;
    private static Category _log = Category.getInstance((String)(class$middlegen$plugins$entitybean$Entity11Plugin == null ? (class$middlegen$plugins$entitybean$Entity11Plugin = Entity11Plugin.class$("middlegen.plugins.entitybean.Entity11Plugin")) : class$middlegen$plugins$entitybean$Entity11Plugin).getName());
    static /* synthetic */ Class class$middlegen$plugins$entitybean$Entity11Plugin;
    static /* synthetic */ Class class$middlegen$plugins$entitybean$Entity11Column;
    static /* synthetic */ Class class$middlegen$plugins$entitybean$Entity11Table;

    protected Entity11Plugin() {
    }

    public void setGuid(boolean guid) {
        this._guid = guid;
    }

    public void setDataobject(boolean dataobject) {
        this._dataobject = dataobject;
    }

    public void setValueobject(boolean valueobject) {
        this._valueobject = valueobject;
    }

    public void setSessionfacade(boolean sessionFacade) {
        this._sessionFacade = sessionFacade;
    }

    public void setPkclass(boolean flag) {
        this._pkClass = flag;
    }

    public void setGeneratepk(boolean flag) {
        _log.warn((Object)"The generatepk attribute is deprecated and will be removed in a future version of Middlegen. Please use the pkclass attribute instead.");
        this.setPkclass(flag);
    }

    public void setReadonly(boolean flag) {
        this._isReadonly = flag;
    }

    public void setJndiprefix(String jndiPrefix) {
        this._jndiPrefix = jndiPrefix;
    }

    public void setInterfacepackage(String interfacePackage) {
        if (interfacePackage.trim().equals("")) {
            throw new IllegalArgumentException("Can't use empty String for interfacepackage!");
        }
        this._interfacePackage = interfacePackage;
    }

    public void setBeansuffix(String s) {
        this._beansuffix = s;
    }

    public void setRemotesuffix(String s) {
        this._remotesuffix = s;
    }

    public void setRemotehomesuffix(String s) {
        this._remotehomesuffix = s;
    }

    public void setDatasuffix(String s) {
        this._datasuffix = s;
    }

    public void setPkpattern(String s) {
        this._pkpattern = s;
    }

    public void setPksuffix(String s) {
        this._pksuffix = s;
    }

    public void setBeanBaseClass(String s) {
        this._beanBaseClass = s;
    }

    public boolean isGuid() {
        return this._guid;
    }

    public boolean isPkgen() {
        boolean sequenceBlock = this.getSequenceblock() != null;
        boolean oraclesequence = this.getOracleSequence() != null;
        boolean weblogic = false;
        if (this.getWeblogic() != null) {
            weblogic = this.getWeblogic().getGeneratorType() != null;
        }
        return sequenceBlock || weblogic || oraclesequence;
    }

    public Weblogic getWeblogic() {
        return this._weblogic;
    }

    public JBoss getJBoss() {
        return this._jboss;
    }

    public JOnAS getJOnAS() {
        return this._jonas;
    }

    public MVCSoft getMvcsoft() {
        return this._mvcsoft;
    }

    public boolean isReadonly() {
        return this._isReadonly;
    }

    public boolean getDataobject() {
        return this._dataobject;
    }

    public boolean getValueobject() {
        return this._valueobject;
    }

    public boolean getSessionfacade() {
        return this._sessionFacade;
    }

    public boolean isPkClass() {
        return this._pkClass;
    }

    public String getJNDIPrefix() {
        return this._jndiPrefix;
    }

    public String getBeansuffix() {
        return this._beansuffix;
    }

    public String getUtilsuffix() {
        return this._utilsuffix;
    }

    public String getRemotesuffix() {
        return this._remotesuffix;
    }

    public String getRemotehomesuffix() {
        return this._remotehomesuffix;
    }

    public String getDatasuffix() {
        return this._datasuffix;
    }

    public String getPkpattern() {
        return this._pkpattern;
    }

    public String getPksuffix() {
        return this._pksuffix;
    }

    public String getBeanBaseClass() {
        return this._beanBaseClass;
    }

    public Class getColumnDecoratorClass() {
        return class$middlegen$plugins$entitybean$Entity11Column == null ? (class$middlegen$plugins$entitybean$Entity11Column = Entity11Plugin.class$("middlegen.plugins.entitybean.Entity11Column")) : class$middlegen$plugins$entitybean$Entity11Column;
    }

    public Class getTableDecoratorClass() {
        return class$middlegen$plugins$entitybean$Entity11Table == null ? (class$middlegen$plugins$entitybean$Entity11Table = Entity11Plugin.class$("middlegen.plugins.entitybean.Entity11Table")) : class$middlegen$plugins$entitybean$Entity11Table;
    }

    public String getInterfacePackage() {
        return this._interfacePackage != null ? this._interfacePackage : this.getPackage() + ".interfaces";
    }

    public BooleanNode getRemote() {
        return this._isRemote;
    }

    public Predicate getFindersPredicate() {
        if (this._finders != null) {
            return this._finders.getPredicate();
        }
        return NotKey.getInstance();
    }

    public SequenceBlock getSequenceblock() {
        return this._sequenceBlock;
    }

    public OracleSequence getOracleSequence() {
        return this._oracleSequence;
    }

    public DynamicPredicate createFinders() {
        ColumnPredicateFactory predicateFactory = new ColumnPredicateFactory();
        this._finders = new DynamicPredicate((PredicateFactory)predicateFactory);
        return this._finders;
    }

    public void addWeblogic(Weblogic weblogic) {
        this._weblogic = weblogic;
        this._weblogic.setPlugin(this);
        this._servers.add(this._weblogic);
    }

    public void addJBoss(JBoss jboss) {
        this._jboss = jboss;
        this._jboss.setPlugin(this);
        this._servers.add(this._jboss);
    }

    public void addJOnAS(JOnAS jonas) {
        this._jonas = jonas;
        this._jonas.setPlugin(this);
        this._servers.add(this._jonas);
    }

    public void addMvcsoft(MVCSoft mvcsoft) {
        this._mvcsoft = mvcsoft;
        this._mvcsoft.setPlugin(this);
        this._servers.add(this._mvcsoft);
    }

    public void addSequenceblock(SequenceBlock sequenceBlock) {
        this._sequenceBlock = sequenceBlock;
        this._sequenceBlock.setPlugin(this);
    }

    public void addOracleSequence(OracleSequence oracleSequence) {
        this._oracleSequence = oracleSequence;
        this._oracleSequence.setPlugin(this);
    }

    public void validate() throws MiddlegenException {
        super.validate();
        if (this._finders != null && this._finders.getPredicate() == null) {
            throw new MiddlegenException("The <finders/> element can't be empty!");
        }
        if (this.getSequenceblock() != null && this.getOracleSequence() != null) {
            throw new MiddlegenException("Elements <sequenceblock/> and <oraclesequence can not be present in one <cmp20>-Element!");
        }
        Iterator servers = this._servers.iterator();
        while (servers.hasNext()) {
            Server server = (Server)servers.next();
            server.validate();
        }
    }

    protected void registerFileProducers() {
        super.registerFileProducers();
        if (this.getSequenceblock() != null) {
            this.addConfiguredFileproducer(new FileProducer(this.getDestinationDir(), this.getSequenceblock().getPackage().replace('.', '/') + "/SequenceSessionBean.java", ((Object)((Object)this)).getClass().getResource("sequence-session-bean.vm")));
            this.addConfiguredFileproducer(new FileProducer(this.getDestinationDir(), this.getSequenceblock().getPackage().replace('.', '/') + "/SequenceBean.java", ((Object)((Object)this)).getClass().getResource("sequence-bean.vm")));
        }
        if (this.getOracleSequence() != null) {
            this.addConfiguredFileproducer(new FileProducer(this.getDestinationDir(), this.getOracleSequence().getPackage().replace('.', '/') + "/OracleSequenceSessionBean.java", ((Object)((Object)this)).getClass().getResource("oracle-sequence-session-bean.vm")));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

