/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.mixer.adapter.cloudwatch;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import me.snowdrop.istio.mixer.adapter.cloudwatch.Cloudwatch;
import me.snowdrop.istio.mixer.adapter.cloudwatch.CloudwatchFluent;
import me.snowdrop.istio.mixer.adapter.cloudwatch.LogInfo;
import me.snowdrop.istio.mixer.adapter.cloudwatch.MetricDatum;

public class CloudwatchFluentImpl<A extends CloudwatchFluent<A>>
extends BaseFluent<A>
implements CloudwatchFluent<A> {
    private String logGroupName;
    private String logStreamName;
    private Map<String, LogInfo> logs;
    private Map<String, MetricDatum> metricInfo;
    private String namespace;

    public CloudwatchFluentImpl() {
    }

    public CloudwatchFluentImpl(Cloudwatch instance) {
        this.withLogGroupName(instance.getLogGroupName());
        this.withLogStreamName(instance.getLogStreamName());
        this.withLogs(instance.getLogs());
        this.withMetricInfo(instance.getMetricInfo());
        this.withNamespace(instance.getNamespace());
    }

    @Override
    public String getLogGroupName() {
        return this.logGroupName;
    }

    @Override
    public A withLogGroupName(String logGroupName) {
        this.logGroupName = logGroupName;
        return (A)this;
    }

    @Override
    public Boolean hasLogGroupName() {
        return this.logGroupName != null;
    }

    @Override
    public A withNewLogGroupName(String arg1) {
        return this.withLogGroupName(new String(arg1));
    }

    @Override
    public A withNewLogGroupName(StringBuilder arg1) {
        return this.withLogGroupName(new String(arg1));
    }

    @Override
    public A withNewLogGroupName(StringBuffer arg1) {
        return this.withLogGroupName(new String(arg1));
    }

    @Override
    public String getLogStreamName() {
        return this.logStreamName;
    }

    @Override
    public A withLogStreamName(String logStreamName) {
        this.logStreamName = logStreamName;
        return (A)this;
    }

    @Override
    public Boolean hasLogStreamName() {
        return this.logStreamName != null;
    }

    @Override
    public A withNewLogStreamName(String arg1) {
        return this.withLogStreamName(new String(arg1));
    }

    @Override
    public A withNewLogStreamName(StringBuilder arg1) {
        return this.withLogStreamName(new String(arg1));
    }

    @Override
    public A withNewLogStreamName(StringBuffer arg1) {
        return this.withLogStreamName(new String(arg1));
    }

    @Override
    public A addToLogs(String key, LogInfo value) {
        if (this.logs == null && key != null && value != null) {
            this.logs = new LinkedHashMap<String, LogInfo>();
        }
        if (key != null && value != null) {
            this.logs.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToLogs(Map<String, LogInfo> map) {
        if (this.logs == null && map != null) {
            this.logs = new LinkedHashMap<String, LogInfo>();
        }
        if (map != null) {
            this.logs.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromLogs(String key) {
        if (this.logs == null) {
            return (A)this;
        }
        if (key != null && this.logs != null) {
            this.logs.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromLogs(Map<String, LogInfo> map) {
        if (this.logs == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.logs == null) continue;
                this.logs.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, LogInfo> getLogs() {
        return this.logs;
    }

    @Override
    public A withLogs(Map<String, LogInfo> logs) {
        this.logs = logs == null ? null : new LinkedHashMap<String, LogInfo>(logs);
        return (A)this;
    }

    @Override
    public Boolean hasLogs() {
        return this.logs != null;
    }

    @Override
    public A addToMetricInfo(String key, MetricDatum value) {
        if (this.metricInfo == null && key != null && value != null) {
            this.metricInfo = new LinkedHashMap<String, MetricDatum>();
        }
        if (key != null && value != null) {
            this.metricInfo.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToMetricInfo(Map<String, MetricDatum> map) {
        if (this.metricInfo == null && map != null) {
            this.metricInfo = new LinkedHashMap<String, MetricDatum>();
        }
        if (map != null) {
            this.metricInfo.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromMetricInfo(String key) {
        if (this.metricInfo == null) {
            return (A)this;
        }
        if (key != null && this.metricInfo != null) {
            this.metricInfo.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromMetricInfo(Map<String, MetricDatum> map) {
        if (this.metricInfo == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.metricInfo == null) continue;
                this.metricInfo.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, MetricDatum> getMetricInfo() {
        return this.metricInfo;
    }

    @Override
    public A withMetricInfo(Map<String, MetricDatum> metricInfo) {
        this.metricInfo = metricInfo == null ? null : new LinkedHashMap<String, MetricDatum>(metricInfo);
        return (A)this;
    }

    @Override
    public Boolean hasMetricInfo() {
        return this.metricInfo != null;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public A withNamespace(String namespace) {
        this.namespace = namespace;
        return (A)this;
    }

    @Override
    public Boolean hasNamespace() {
        return this.namespace != null;
    }

    @Override
    public A withNewNamespace(String arg1) {
        return this.withNamespace(new String(arg1));
    }

    @Override
    public A withNewNamespace(StringBuilder arg1) {
        return this.withNamespace(new String(arg1));
    }

    @Override
    public A withNewNamespace(StringBuffer arg1) {
        return this.withNamespace(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CloudwatchFluentImpl that = (CloudwatchFluentImpl)o;
        if (this.logGroupName != null ? !this.logGroupName.equals(that.logGroupName) : that.logGroupName != null) {
            return false;
        }
        if (this.logStreamName != null ? !this.logStreamName.equals(that.logStreamName) : that.logStreamName != null) {
            return false;
        }
        if (this.logs != null ? !this.logs.equals(that.logs) : that.logs != null) {
            return false;
        }
        if (this.metricInfo != null ? !this.metricInfo.equals(that.metricInfo) : that.metricInfo != null) {
            return false;
        }
        return !(this.namespace != null ? !this.namespace.equals(that.namespace) : that.namespace != null);
    }
}

