/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.api.security.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import me.snowdrop.istio.api.security.v1beta1.JWTHeader;
import me.snowdrop.istio.api.security.v1beta1.JWTHeaderBuilder;
import me.snowdrop.istio.api.security.v1beta1.JWTHeaderFluentImpl;
import me.snowdrop.istio.api.security.v1beta1.JWTRule;
import me.snowdrop.istio.api.security.v1beta1.JWTRuleFluent;

public class JWTRuleFluentImpl<A extends JWTRuleFluent<A>>
extends BaseFluent<A>
implements JWTRuleFluent<A> {
    private List<String> audiences;
    private Boolean forwardOriginalToken;
    private List<JWTHeaderBuilder> fromHeaders;
    private List<String> fromParams;
    private String issuer;
    private String jwks;
    private String jwksUri;
    private String outputPayloadToHeader;

    public JWTRuleFluentImpl() {
    }

    public JWTRuleFluentImpl(JWTRule instance) {
        this.withAudiences(instance.getAudiences());
        this.withForwardOriginalToken(instance.getForwardOriginalToken());
        this.withFromHeaders(instance.getFromHeaders());
        this.withFromParams(instance.getFromParams());
        this.withIssuer(instance.getIssuer());
        this.withJwks(instance.getJwks());
        this.withJwksUri(instance.getJwksUri());
        this.withOutputPayloadToHeader(instance.getOutputPayloadToHeader());
    }

    @Override
    public A addToAudiences(int index, String item) {
        if (this.audiences == null) {
            this.audiences = new ArrayList<String>();
        }
        this.audiences.add(index, item);
        return (A)this;
    }

    @Override
    public A setToAudiences(int index, String item) {
        if (this.audiences == null) {
            this.audiences = new ArrayList<String>();
        }
        this.audiences.set(index, item);
        return (A)this;
    }

    @Override
    public A addToAudiences(String ... items) {
        if (this.audiences == null) {
            this.audiences = new ArrayList<String>();
        }
        for (String item : items) {
            this.audiences.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToAudiences(Collection<String> items) {
        if (this.audiences == null) {
            this.audiences = new ArrayList<String>();
        }
        for (String item : items) {
            this.audiences.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromAudiences(String ... items) {
        for (String item : items) {
            if (this.audiences == null) continue;
            this.audiences.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAudiences(Collection<String> items) {
        for (String item : items) {
            if (this.audiences == null) continue;
            this.audiences.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getAudiences() {
        return this.audiences;
    }

    @Override
    public String getAudience(int index) {
        return this.audiences.get(index);
    }

    @Override
    public String getFirstAudience() {
        return this.audiences.get(0);
    }

    @Override
    public String getLastAudience() {
        return this.audiences.get(this.audiences.size() - 1);
    }

    @Override
    public String getMatchingAudience(Predicate<String> predicate) {
        for (String item : this.audiences) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingAudience(Predicate<String> predicate) {
        for (String item : this.audiences) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withAudiences(List<String> audiences) {
        if (this.audiences != null) {
            this._visitables.get((Object)"audiences").removeAll(this.audiences);
        }
        if (audiences != null) {
            this.audiences = new ArrayList<String>();
            for (String item : audiences) {
                this.addToAudiences(item);
            }
        } else {
            this.audiences = null;
        }
        return (A)this;
    }

    @Override
    public A withAudiences(String ... audiences) {
        if (this.audiences != null) {
            this.audiences.clear();
        }
        if (audiences != null) {
            for (String item : audiences) {
                this.addToAudiences(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAudiences() {
        return this.audiences != null && !this.audiences.isEmpty();
    }

    @Override
    public A addNewAudience(String arg1) {
        return this.addToAudiences(new String(arg1));
    }

    @Override
    public A addNewAudience(StringBuilder arg1) {
        return this.addToAudiences(new String(arg1));
    }

    @Override
    public A addNewAudience(StringBuffer arg1) {
        return this.addToAudiences(new String(arg1));
    }

    @Override
    public Boolean isForwardOriginalToken() {
        return this.forwardOriginalToken;
    }

    @Override
    public A withForwardOriginalToken(Boolean forwardOriginalToken) {
        this.forwardOriginalToken = forwardOriginalToken;
        return (A)this;
    }

    @Override
    public Boolean hasForwardOriginalToken() {
        return this.forwardOriginalToken != null;
    }

    @Override
    public A withNewForwardOriginalToken(String arg1) {
        return this.withForwardOriginalToken(new Boolean(arg1));
    }

    @Override
    public A withNewForwardOriginalToken(boolean arg1) {
        return this.withForwardOriginalToken(new Boolean(arg1));
    }

    @Override
    public A addToFromHeaders(int index, JWTHeader item) {
        if (this.fromHeaders == null) {
            this.fromHeaders = new ArrayList<JWTHeaderBuilder>();
        }
        JWTHeaderBuilder builder = new JWTHeaderBuilder(item);
        this._visitables.get((Object)"fromHeaders").add(index >= 0 ? index : this._visitables.get((Object)"fromHeaders").size(), builder);
        this.fromHeaders.add(index >= 0 ? index : this.fromHeaders.size(), builder);
        return (A)this;
    }

    @Override
    public A setToFromHeaders(int index, JWTHeader item) {
        if (this.fromHeaders == null) {
            this.fromHeaders = new ArrayList<JWTHeaderBuilder>();
        }
        JWTHeaderBuilder builder = new JWTHeaderBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"fromHeaders").size()) {
            this._visitables.get((Object)"fromHeaders").add(builder);
        } else {
            this._visitables.get((Object)"fromHeaders").set(index, builder);
        }
        if (index < 0 || index >= this.fromHeaders.size()) {
            this.fromHeaders.add(builder);
        } else {
            this.fromHeaders.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToFromHeaders(JWTHeader ... items) {
        if (this.fromHeaders == null) {
            this.fromHeaders = new ArrayList<JWTHeaderBuilder>();
        }
        for (JWTHeader item : items) {
            JWTHeaderBuilder builder = new JWTHeaderBuilder(item);
            this._visitables.get((Object)"fromHeaders").add(builder);
            this.fromHeaders.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToFromHeaders(Collection<JWTHeader> items) {
        if (this.fromHeaders == null) {
            this.fromHeaders = new ArrayList<JWTHeaderBuilder>();
        }
        for (JWTHeader item : items) {
            JWTHeaderBuilder builder = new JWTHeaderBuilder(item);
            this._visitables.get((Object)"fromHeaders").add(builder);
            this.fromHeaders.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromFromHeaders(JWTHeader ... items) {
        for (JWTHeader item : items) {
            JWTHeaderBuilder builder = new JWTHeaderBuilder(item);
            this._visitables.get((Object)"fromHeaders").remove(builder);
            if (this.fromHeaders == null) continue;
            this.fromHeaders.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromFromHeaders(Collection<JWTHeader> items) {
        for (JWTHeader item : items) {
            JWTHeaderBuilder builder = new JWTHeaderBuilder(item);
            this._visitables.get((Object)"fromHeaders").remove(builder);
            if (this.fromHeaders == null) continue;
            this.fromHeaders.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromFromHeaders(Predicate<JWTHeaderBuilder> predicate) {
        if (this.fromHeaders == null) {
            return (A)this;
        }
        Iterator<JWTHeaderBuilder> each = this.fromHeaders.iterator();
        List visitables = this._visitables.get((Object)"fromHeaders");
        while (each.hasNext()) {
            JWTHeaderBuilder builder = each.next();
            if (!predicate.apply(builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<JWTHeader> getFromHeaders() {
        return JWTRuleFluentImpl.build(this.fromHeaders);
    }

    @Override
    public List<JWTHeader> buildFromHeaders() {
        return JWTRuleFluentImpl.build(this.fromHeaders);
    }

    @Override
    public JWTHeader buildFromHeader(int index) {
        return this.fromHeaders.get(index).build();
    }

    @Override
    public JWTHeader buildFirstFromHeader() {
        return this.fromHeaders.get(0).build();
    }

    @Override
    public JWTHeader buildLastFromHeader() {
        return this.fromHeaders.get(this.fromHeaders.size() - 1).build();
    }

    @Override
    public JWTHeader buildMatchingFromHeader(Predicate<JWTHeaderBuilder> predicate) {
        for (JWTHeaderBuilder item : this.fromHeaders) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingFromHeader(Predicate<JWTHeaderBuilder> predicate) {
        for (JWTHeaderBuilder item : this.fromHeaders) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withFromHeaders(List<JWTHeader> fromHeaders) {
        if (this.fromHeaders != null) {
            this._visitables.get((Object)"fromHeaders").removeAll(this.fromHeaders);
        }
        if (fromHeaders != null) {
            this.fromHeaders = new ArrayList<JWTHeaderBuilder>();
            for (JWTHeader item : fromHeaders) {
                this.addToFromHeaders(item);
            }
        } else {
            this.fromHeaders = null;
        }
        return (A)this;
    }

    @Override
    public A withFromHeaders(JWTHeader ... fromHeaders) {
        if (this.fromHeaders != null) {
            this.fromHeaders.clear();
        }
        if (fromHeaders != null) {
            for (JWTHeader item : fromHeaders) {
                this.addToFromHeaders(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasFromHeaders() {
        return this.fromHeaders != null && !this.fromHeaders.isEmpty();
    }

    @Override
    public A addNewFromHeader(String name, String prefix) {
        return this.addToFromHeaders(new JWTHeader(name, prefix));
    }

    @Override
    public JWTRuleFluent.FromHeadersNested<A> addNewFromHeader() {
        return new FromHeadersNestedImpl();
    }

    @Override
    public JWTRuleFluent.FromHeadersNested<A> addNewFromHeaderLike(JWTHeader item) {
        return new FromHeadersNestedImpl(-1, item);
    }

    @Override
    public JWTRuleFluent.FromHeadersNested<A> setNewFromHeaderLike(int index, JWTHeader item) {
        return new FromHeadersNestedImpl(index, item);
    }

    @Override
    public JWTRuleFluent.FromHeadersNested<A> editFromHeader(int index) {
        if (this.fromHeaders.size() <= index) {
            throw new RuntimeException("Can't edit fromHeaders. Index exceeds size.");
        }
        return this.setNewFromHeaderLike(index, this.buildFromHeader(index));
    }

    @Override
    public JWTRuleFluent.FromHeadersNested<A> editFirstFromHeader() {
        if (this.fromHeaders.size() == 0) {
            throw new RuntimeException("Can't edit first fromHeaders. The list is empty.");
        }
        return this.setNewFromHeaderLike(0, this.buildFromHeader(0));
    }

    @Override
    public JWTRuleFluent.FromHeadersNested<A> editLastFromHeader() {
        int index = this.fromHeaders.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last fromHeaders. The list is empty.");
        }
        return this.setNewFromHeaderLike(index, this.buildFromHeader(index));
    }

    @Override
    public JWTRuleFluent.FromHeadersNested<A> editMatchingFromHeader(Predicate<JWTHeaderBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.fromHeaders.size(); ++i) {
            if (!predicate.apply(this.fromHeaders.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching fromHeaders. No match found.");
        }
        return this.setNewFromHeaderLike(index, this.buildFromHeader(index));
    }

    @Override
    public A addToFromParams(int index, String item) {
        if (this.fromParams == null) {
            this.fromParams = new ArrayList<String>();
        }
        this.fromParams.add(index, item);
        return (A)this;
    }

    @Override
    public A setToFromParams(int index, String item) {
        if (this.fromParams == null) {
            this.fromParams = new ArrayList<String>();
        }
        this.fromParams.set(index, item);
        return (A)this;
    }

    @Override
    public A addToFromParams(String ... items) {
        if (this.fromParams == null) {
            this.fromParams = new ArrayList<String>();
        }
        for (String item : items) {
            this.fromParams.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToFromParams(Collection<String> items) {
        if (this.fromParams == null) {
            this.fromParams = new ArrayList<String>();
        }
        for (String item : items) {
            this.fromParams.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromFromParams(String ... items) {
        for (String item : items) {
            if (this.fromParams == null) continue;
            this.fromParams.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromFromParams(Collection<String> items) {
        for (String item : items) {
            if (this.fromParams == null) continue;
            this.fromParams.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getFromParams() {
        return this.fromParams;
    }

    @Override
    public String getFromParam(int index) {
        return this.fromParams.get(index);
    }

    @Override
    public String getFirstFromParam() {
        return this.fromParams.get(0);
    }

    @Override
    public String getLastFromParam() {
        return this.fromParams.get(this.fromParams.size() - 1);
    }

    @Override
    public String getMatchingFromParam(Predicate<String> predicate) {
        for (String item : this.fromParams) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingFromParam(Predicate<String> predicate) {
        for (String item : this.fromParams) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withFromParams(List<String> fromParams) {
        if (this.fromParams != null) {
            this._visitables.get((Object)"fromParams").removeAll(this.fromParams);
        }
        if (fromParams != null) {
            this.fromParams = new ArrayList<String>();
            for (String item : fromParams) {
                this.addToFromParams(item);
            }
        } else {
            this.fromParams = null;
        }
        return (A)this;
    }

    @Override
    public A withFromParams(String ... fromParams) {
        if (this.fromParams != null) {
            this.fromParams.clear();
        }
        if (fromParams != null) {
            for (String item : fromParams) {
                this.addToFromParams(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasFromParams() {
        return this.fromParams != null && !this.fromParams.isEmpty();
    }

    @Override
    public A addNewFromParam(String arg1) {
        return this.addToFromParams(new String(arg1));
    }

    @Override
    public A addNewFromParam(StringBuilder arg1) {
        return this.addToFromParams(new String(arg1));
    }

    @Override
    public A addNewFromParam(StringBuffer arg1) {
        return this.addToFromParams(new String(arg1));
    }

    @Override
    public String getIssuer() {
        return this.issuer;
    }

    @Override
    public A withIssuer(String issuer) {
        this.issuer = issuer;
        return (A)this;
    }

    @Override
    public Boolean hasIssuer() {
        return this.issuer != null;
    }

    @Override
    public A withNewIssuer(String arg1) {
        return this.withIssuer(new String(arg1));
    }

    @Override
    public A withNewIssuer(StringBuilder arg1) {
        return this.withIssuer(new String(arg1));
    }

    @Override
    public A withNewIssuer(StringBuffer arg1) {
        return this.withIssuer(new String(arg1));
    }

    @Override
    public String getJwks() {
        return this.jwks;
    }

    @Override
    public A withJwks(String jwks) {
        this.jwks = jwks;
        return (A)this;
    }

    @Override
    public Boolean hasJwks() {
        return this.jwks != null;
    }

    @Override
    public A withNewJwks(String arg1) {
        return this.withJwks(new String(arg1));
    }

    @Override
    public A withNewJwks(StringBuilder arg1) {
        return this.withJwks(new String(arg1));
    }

    @Override
    public A withNewJwks(StringBuffer arg1) {
        return this.withJwks(new String(arg1));
    }

    @Override
    public String getJwksUri() {
        return this.jwksUri;
    }

    @Override
    public A withJwksUri(String jwksUri) {
        this.jwksUri = jwksUri;
        return (A)this;
    }

    @Override
    public Boolean hasJwksUri() {
        return this.jwksUri != null;
    }

    @Override
    public A withNewJwksUri(String arg1) {
        return this.withJwksUri(new String(arg1));
    }

    @Override
    public A withNewJwksUri(StringBuilder arg1) {
        return this.withJwksUri(new String(arg1));
    }

    @Override
    public A withNewJwksUri(StringBuffer arg1) {
        return this.withJwksUri(new String(arg1));
    }

    @Override
    public String getOutputPayloadToHeader() {
        return this.outputPayloadToHeader;
    }

    @Override
    public A withOutputPayloadToHeader(String outputPayloadToHeader) {
        this.outputPayloadToHeader = outputPayloadToHeader;
        return (A)this;
    }

    @Override
    public Boolean hasOutputPayloadToHeader() {
        return this.outputPayloadToHeader != null;
    }

    @Override
    public A withNewOutputPayloadToHeader(String arg1) {
        return this.withOutputPayloadToHeader(new String(arg1));
    }

    @Override
    public A withNewOutputPayloadToHeader(StringBuilder arg1) {
        return this.withOutputPayloadToHeader(new String(arg1));
    }

    @Override
    public A withNewOutputPayloadToHeader(StringBuffer arg1) {
        return this.withOutputPayloadToHeader(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JWTRuleFluentImpl that = (JWTRuleFluentImpl)o;
        if (this.audiences != null ? !this.audiences.equals(that.audiences) : that.audiences != null) {
            return false;
        }
        if (this.forwardOriginalToken != null ? !this.forwardOriginalToken.equals(that.forwardOriginalToken) : that.forwardOriginalToken != null) {
            return false;
        }
        if (this.fromHeaders != null ? !this.fromHeaders.equals(that.fromHeaders) : that.fromHeaders != null) {
            return false;
        }
        if (this.fromParams != null ? !this.fromParams.equals(that.fromParams) : that.fromParams != null) {
            return false;
        }
        if (this.issuer != null ? !this.issuer.equals(that.issuer) : that.issuer != null) {
            return false;
        }
        if (this.jwks != null ? !this.jwks.equals(that.jwks) : that.jwks != null) {
            return false;
        }
        if (this.jwksUri != null ? !this.jwksUri.equals(that.jwksUri) : that.jwksUri != null) {
            return false;
        }
        return !(this.outputPayloadToHeader != null ? !this.outputPayloadToHeader.equals(that.outputPayloadToHeader) : that.outputPayloadToHeader != null);
    }

    public class FromHeadersNestedImpl<N>
    extends JWTHeaderFluentImpl<JWTRuleFluent.FromHeadersNested<N>>
    implements JWTRuleFluent.FromHeadersNested<N>,
    Nested<N> {
        private final JWTHeaderBuilder builder;
        private final int index;

        FromHeadersNestedImpl(int index, JWTHeader item) {
            this.index = index;
            this.builder = new JWTHeaderBuilder(this, item);
        }

        FromHeadersNestedImpl() {
            this.index = -1;
            this.builder = new JWTHeaderBuilder(this);
        }

        @Override
        public N and() {
            return (N)JWTRuleFluentImpl.this.setToFromHeaders(this.index, this.builder.build());
        }

        @Override
        public N endFromHeader() {
            return this.and();
        }
    }
}

