/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.api.mesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.snowdrop.istio.api.mesh.v1alpha1.ServiceSettings;
import me.snowdrop.istio.api.mesh.v1alpha1.ServiceSettingsFluent;
import me.snowdrop.istio.api.mesh.v1alpha1.Settings;
import me.snowdrop.istio.api.mesh.v1alpha1.SettingsBuilder;
import me.snowdrop.istio.api.mesh.v1alpha1.SettingsFluentImpl;

public class ServiceSettingsFluentImpl<A extends ServiceSettingsFluent<A>>
extends BaseFluent<A>
implements ServiceSettingsFluent<A> {
    private List<String> hosts;
    private SettingsBuilder settings;

    public ServiceSettingsFluentImpl() {
    }

    public ServiceSettingsFluentImpl(ServiceSettings instance) {
        this.withHosts(instance.getHosts());
        this.withSettings(instance.getSettings());
    }

    @Override
    public A addToHosts(int index, String item) {
        if (this.hosts == null) {
            this.hosts = new ArrayList<String>();
        }
        this.hosts.add(index, item);
        return (A)this;
    }

    @Override
    public A setToHosts(int index, String item) {
        if (this.hosts == null) {
            this.hosts = new ArrayList<String>();
        }
        this.hosts.set(index, item);
        return (A)this;
    }

    @Override
    public A addToHosts(String ... items) {
        if (this.hosts == null) {
            this.hosts = new ArrayList<String>();
        }
        for (String item : items) {
            this.hosts.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToHosts(Collection<String> items) {
        if (this.hosts == null) {
            this.hosts = new ArrayList<String>();
        }
        for (String item : items) {
            this.hosts.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromHosts(String ... items) {
        for (String item : items) {
            if (this.hosts == null) continue;
            this.hosts.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromHosts(Collection<String> items) {
        for (String item : items) {
            if (this.hosts == null) continue;
            this.hosts.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getHosts() {
        return this.hosts;
    }

    @Override
    public String getHost(int index) {
        return this.hosts.get(index);
    }

    @Override
    public String getFirstHost() {
        return this.hosts.get(0);
    }

    @Override
    public String getLastHost() {
        return this.hosts.get(this.hosts.size() - 1);
    }

    @Override
    public String getMatchingHost(Predicate<String> predicate) {
        for (String item : this.hosts) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingHost(Predicate<String> predicate) {
        for (String item : this.hosts) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withHosts(List<String> hosts) {
        if (this.hosts != null) {
            this._visitables.get((Object)"hosts").removeAll(this.hosts);
        }
        if (hosts != null) {
            this.hosts = new ArrayList<String>();
            for (String item : hosts) {
                this.addToHosts(item);
            }
        } else {
            this.hosts = null;
        }
        return (A)this;
    }

    @Override
    public A withHosts(String ... hosts) {
        if (this.hosts != null) {
            this.hosts.clear();
        }
        if (hosts != null) {
            for (String item : hosts) {
                this.addToHosts(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasHosts() {
        return this.hosts != null && !this.hosts.isEmpty();
    }

    @Override
    public A addNewHost(String arg1) {
        return this.addToHosts(new String(arg1));
    }

    @Override
    public A addNewHost(StringBuilder arg1) {
        return this.addToHosts(new String(arg1));
    }

    @Override
    public A addNewHost(StringBuffer arg1) {
        return this.addToHosts(new String(arg1));
    }

    @Override
    @Deprecated
    public Settings getSettings() {
        return this.settings != null ? this.settings.build() : null;
    }

    @Override
    public Settings buildSettings() {
        return this.settings != null ? this.settings.build() : null;
    }

    @Override
    public A withSettings(Settings settings) {
        this._visitables.get((Object)"settings").remove(this.settings);
        if (settings != null) {
            this.settings = new SettingsBuilder(settings);
            this._visitables.get((Object)"settings").add(this.settings);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSettings() {
        return this.settings != null;
    }

    @Override
    public A withNewSettings(Boolean clusterLocal) {
        return this.withSettings(new Settings(clusterLocal));
    }

    @Override
    public ServiceSettingsFluent.SettingsNested<A> withNewSettings() {
        return new SettingsNestedImpl();
    }

    @Override
    public ServiceSettingsFluent.SettingsNested<A> withNewSettingsLike(Settings item) {
        return new SettingsNestedImpl(item);
    }

    @Override
    public ServiceSettingsFluent.SettingsNested<A> editSettings() {
        return this.withNewSettingsLike(this.getSettings());
    }

    @Override
    public ServiceSettingsFluent.SettingsNested<A> editOrNewSettings() {
        return this.withNewSettingsLike(this.getSettings() != null ? this.getSettings() : new SettingsBuilder().build());
    }

    @Override
    public ServiceSettingsFluent.SettingsNested<A> editOrNewSettingsLike(Settings item) {
        return this.withNewSettingsLike(this.getSettings() != null ? this.getSettings() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceSettingsFluentImpl that = (ServiceSettingsFluentImpl)o;
        if (this.hosts != null ? !this.hosts.equals(that.hosts) : that.hosts != null) {
            return false;
        }
        return !(this.settings != null ? !this.settings.equals(that.settings) : that.settings != null);
    }

    public class SettingsNestedImpl<N>
    extends SettingsFluentImpl<ServiceSettingsFluent.SettingsNested<N>>
    implements ServiceSettingsFluent.SettingsNested<N>,
    Nested<N> {
        private final SettingsBuilder builder;

        SettingsNestedImpl(Settings item) {
            this.builder = new SettingsBuilder(this, item);
        }

        SettingsNestedImpl() {
            this.builder = new SettingsBuilder(this);
        }

        @Override
        public N and() {
            return (N)ServiceSettingsFluentImpl.this.withSettings(this.builder.build());
        }

        @Override
        public N endSettings() {
            return this.and();
        }
    }
}

