/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.api.mesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import me.snowdrop.istio.api.mesh.v1alpha1.ConfigSource;
import me.snowdrop.istio.api.mesh.v1alpha1.ConfigSourceFluent;
import me.snowdrop.istio.api.mesh.v1alpha1.Resource;
import me.snowdrop.istio.api.networking.v1alpha3.ClientTLSSettings;
import me.snowdrop.istio.api.networking.v1alpha3.ClientTLSSettingsBuilder;
import me.snowdrop.istio.api.networking.v1alpha3.ClientTLSSettingsFluentImpl;

public class ConfigSourceFluentImpl<A extends ConfigSourceFluent<A>>
extends BaseFluent<A>
implements ConfigSourceFluent<A> {
    private String address;
    private Resource subscribedResources;
    private ClientTLSSettingsBuilder tlsSettings;

    public ConfigSourceFluentImpl() {
    }

    public ConfigSourceFluentImpl(ConfigSource instance) {
        this.withAddress(instance.getAddress());
        this.withSubscribedResources(instance.getSubscribedResources());
        this.withTlsSettings(instance.getTlsSettings());
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    @Override
    public A withAddress(String address) {
        this.address = address;
        return (A)this;
    }

    @Override
    public Boolean hasAddress() {
        return this.address != null;
    }

    @Override
    public A withNewAddress(String arg1) {
        return this.withAddress(new String(arg1));
    }

    @Override
    public A withNewAddress(StringBuilder arg1) {
        return this.withAddress(new String(arg1));
    }

    @Override
    public A withNewAddress(StringBuffer arg1) {
        return this.withAddress(new String(arg1));
    }

    @Override
    public Resource getSubscribedResources() {
        return this.subscribedResources;
    }

    @Override
    public A withSubscribedResources(Resource subscribedResources) {
        this.subscribedResources = subscribedResources;
        return (A)this;
    }

    @Override
    public Boolean hasSubscribedResources() {
        return this.subscribedResources != null;
    }

    @Override
    @Deprecated
    public ClientTLSSettings getTlsSettings() {
        return this.tlsSettings != null ? this.tlsSettings.build() : null;
    }

    @Override
    public ClientTLSSettings buildTlsSettings() {
        return this.tlsSettings != null ? this.tlsSettings.build() : null;
    }

    @Override
    public A withTlsSettings(ClientTLSSettings tlsSettings) {
        this._visitables.get((Object)"tlsSettings").remove(this.tlsSettings);
        if (tlsSettings != null) {
            this.tlsSettings = new ClientTLSSettingsBuilder(tlsSettings);
            this._visitables.get((Object)"tlsSettings").add(this.tlsSettings);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTlsSettings() {
        return this.tlsSettings != null;
    }

    @Override
    public ConfigSourceFluent.TlsSettingsNested<A> withNewTlsSettings() {
        return new TlsSettingsNestedImpl();
    }

    @Override
    public ConfigSourceFluent.TlsSettingsNested<A> withNewTlsSettingsLike(ClientTLSSettings item) {
        return new TlsSettingsNestedImpl(item);
    }

    @Override
    public ConfigSourceFluent.TlsSettingsNested<A> editTlsSettings() {
        return this.withNewTlsSettingsLike(this.getTlsSettings());
    }

    @Override
    public ConfigSourceFluent.TlsSettingsNested<A> editOrNewTlsSettings() {
        return this.withNewTlsSettingsLike(this.getTlsSettings() != null ? this.getTlsSettings() : new ClientTLSSettingsBuilder().build());
    }

    @Override
    public ConfigSourceFluent.TlsSettingsNested<A> editOrNewTlsSettingsLike(ClientTLSSettings item) {
        return this.withNewTlsSettingsLike(this.getTlsSettings() != null ? this.getTlsSettings() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigSourceFluentImpl that = (ConfigSourceFluentImpl)o;
        if (this.address != null ? !this.address.equals(that.address) : that.address != null) {
            return false;
        }
        if (this.subscribedResources != null ? !this.subscribedResources.equals((Object)that.subscribedResources) : that.subscribedResources != null) {
            return false;
        }
        return !(this.tlsSettings != null ? !this.tlsSettings.equals(that.tlsSettings) : that.tlsSettings != null);
    }

    public class TlsSettingsNestedImpl<N>
    extends ClientTLSSettingsFluentImpl<ConfigSourceFluent.TlsSettingsNested<N>>
    implements ConfigSourceFluent.TlsSettingsNested<N>,
    Nested<N> {
        private final ClientTLSSettingsBuilder builder;

        TlsSettingsNestedImpl(ClientTLSSettings item) {
            this.builder = new ClientTLSSettingsBuilder(this, item);
        }

        TlsSettingsNestedImpl() {
            this.builder = new ClientTLSSettingsBuilder(this);
        }

        @Override
        public N and() {
            return (N)ConfigSourceFluentImpl.this.withTlsSettings(this.builder.build());
        }

        @Override
        public N endTlsSettings() {
            return this.and();
        }
    }
}

