/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.util;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class StructHelper {
    public static <T> T get(Map<String, Object> struct, String dotSeparatedPath, Class<T> expectedType) {
        String[] parts = dotSeparatedPath.split("\\.");
        return StructHelper.get(struct, parts, expectedType, new LinkedList<String>(), dotSeparatedPath);
    }

    private static <T> T get(Map struct, String[] parts, Class<T> expectedType, List<String> processed, String dotSeparatedPath) {
        switch (parts.length) {
            case 0: {
                return null;
            }
            case 1: {
                return expectedType.cast(StructHelper.handleNullOrEmptyPath(struct, parts, processed));
            }
        }
        Object o = StructHelper.handleNullOrEmptyPath(struct, parts, processed);
        if (o instanceof Map) {
            Map map = (Map)o;
            String[] newParts = new String[parts.length - 1];
            System.arraycopy(parts, 1, newParts, 0, parts.length - 1);
            return StructHelper.get(map, newParts, expectedType, processed, dotSeparatedPath);
        }
        throw new IllegalArgumentException("'" + dotSeparatedPath + "' is interrupted at '" + String.join((CharSequence)".", processed) + "' because '" + parts[0] + "' is a terminal element");
    }

    private static Object handleNullOrEmptyPath(Map struct, String[] parts, List<String> processed) {
        Object o;
        String part = parts[0];
        if (part.trim().isEmpty()) {
            return struct;
        }
        if (parts.length > 1) {
            processed.add(part);
        }
        if ((o = struct.get(part)) == null) {
            throw new IllegalArgumentException("'" + part + "' is not a child of '" + String.join((CharSequence)".", processed) + "'. Known children: " + struct.keySet().stream().map(k -> "'" + k + "'").collect(Collectors.joining(", ")));
        }
        return o;
    }
}

