/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.api.internal;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.Map;

public interface MixerResourceDeserializer<Spec, Params> {
    public static final String POLYMORPHIC_PARAMS_FIELD = "params";
    public static final String INSTANCE_TYPE_FIELD = "compiledTemplate";
    public static final String HANDLER_TYPE_FIELD = "compiledAdapter";

    default public Object deserialize(JsonParser parser, String resourceType) throws IOException {
        ObjectCodec codec = parser.getCodec();
        ObjectNode node = (ObjectNode)codec.readTree(parser);
        Spec newInstance = this.newInstance();
        Class<?> instanceClass = newInstance.getClass();
        Iterator fields = node.fields();
        while (fields.hasNext()) {
            Map.Entry field = (Map.Entry)fields.next();
            String fieldName = (String)field.getKey();
            try {
                Class<Params> targetClass;
                Field targetClassField = instanceClass.getDeclaredField(fieldName);
                if (fieldName.equals(POLYMORPHIC_PARAMS_FIELD)) {
                    String resourceName = node.findValue(resourceType).textValue();
                    targetClass = this.getImplementationClass(resourceName);
                } else {
                    Type type = targetClassField.getAnnotatedType().getType();
                    targetClass = (Class<Params>)type;
                }
                targetClassField.setAccessible(true);
                Object deserialized = codec.treeToValue((TreeNode)field.getValue(), targetClass);
                targetClassField.set(newInstance, deserialized);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }
        return newInstance;
    }

    public Spec newInstance();

    public Class<? extends Params> getImplementationClass(String var1);
}

