/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.api.internal;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.Map;
import me.snowdrop.istio.api.internal.ClassWithInterfaceFieldsRegistry;

public class ClassWithInterfaceFieldsDeserializer
extends JsonDeserializer
implements ContextualDeserializer {
    private String targetClassName;

    public ClassWithInterfaceFieldsDeserializer() {
    }

    private ClassWithInterfaceFieldsDeserializer(String targetClassName) {
        this.targetClassName = targetClassName;
    }

    public Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        Object result;
        Class<?> targetClass;
        ObjectNode node = (ObjectNode)p.readValueAsTree();
        try {
            targetClass = Thread.currentThread().getContextClassLoader().loadClass(this.targetClassName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(this.targetClassName + " doesn't appear to be a known Istio class", e);
        }
        try {
            result = targetClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Couldn't create an instance of " + this.targetClassName, e);
        }
        Iterator fields = node.fields();
        while (fields.hasNext()) {
            Map.Entry field = (Map.Entry)fields.next();
            String fieldName = (String)field.getKey();
            ClassWithInterfaceFieldsRegistry.FieldInfo info = ClassWithInterfaceFieldsRegistry.getFieldInfo(this.targetClassName, fieldName);
            Object deserialized = info.deserialize((JsonNode)node, fieldName, targetClass, ctxt);
            try {
                Field targetClassField = targetClass.getDeclaredField(info.target());
                targetClassField.setAccessible(true);
                targetClassField.set(result, deserialized);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new RuntimeException("Couldn't assign '" + deserialized + "' to '" + info.target() + "' target field on '" + this.targetClassName + "' class", e);
            }
        }
        return result;
    }

    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        JavaType type;
        Class classToDeserialize = property != null ? ((type = property.getType()).isContainerType() ? type.getContentType().getRawClass() : type.getRawClass()) : ctxt.getContextualType().getRawClass();
        return new ClassWithInterfaceFieldsDeserializer(classToDeserialize.getName());
    }
}

