/*
 * Decompiled with CFR 0.152.
 */
package me.moocar.logbackgelf;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.List;

public class Transport {
    private final InetAddress graylog2ServerAddress;
    private final int graylog2ServerPort;

    public Transport(int graylog2ServerPort, InetAddress graylog2ServerAddress) {
        this.graylog2ServerPort = graylog2ServerPort;
        this.graylog2ServerAddress = graylog2ServerAddress;
    }

    public void send(byte[] data) {
        DatagramPacket datagramPacket = new DatagramPacket(data, data.length, this.graylog2ServerAddress, this.graylog2ServerPort);
        this.sendPacket(datagramPacket);
    }

    public void send(List<byte[]> packets) {
        for (byte[] packet : packets) {
            this.send(packet);
        }
    }

    private void sendPacket(DatagramPacket datagramPacket) {
        DatagramSocket datagramSocket = this.getDatagramSocket();
        try {
            datagramSocket.send(datagramPacket);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            datagramSocket.close();
        }
    }

    private DatagramSocket getDatagramSocket() {
        try {
            return new DatagramSocket();
        }
        catch (SocketException ex) {
            throw new RuntimeException(ex);
        }
    }
}

