/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.amateras.mirage.util;

import java.util.List;
import jp.sf.amateras.mirage.EntityOperator;
import jp.sf.amateras.mirage.annotation.PrimaryKey;
import jp.sf.amateras.mirage.annotation.Table;
import jp.sf.amateras.mirage.bean.BeanDesc;
import jp.sf.amateras.mirage.bean.BeanDescFactory;
import jp.sf.amateras.mirage.bean.PropertyDesc;
import jp.sf.amateras.mirage.dialect.Dialect;
import jp.sf.amateras.mirage.naming.NameConverter;
import jp.sf.amateras.mirage.parser.SqlContext;
import jp.sf.amateras.mirage.parser.SqlContextImpl;
import jp.sf.amateras.mirage.type.ValueType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MirageUtil {
    public static ValueType<?> getValueType(Class<?> propertyType, PropertyDesc propertyDesc, Dialect dialect, List<ValueType<?>> valueTypes) {
        ValueType<?> valueType;
        if (dialect.getValueType() != null && (valueType = dialect.getValueType()).isSupport(propertyType, propertyDesc)) {
            return valueType;
        }
        for (ValueType<?> valueType2 : valueTypes) {
            if (!valueType2.isSupport(propertyType, propertyDesc)) continue;
            return valueType2;
        }
        return null;
    }

    public static SqlContext getSqlContext(BeanDescFactory beanDescFactory, Object param) {
        SqlContextImpl context = new SqlContextImpl();
        if (param != null) {
            BeanDesc beanDesc = beanDescFactory.getBeanDesc(param);
            for (int i = 0; i < beanDesc.getPropertyDescSize(); ++i) {
                PropertyDesc pd = beanDesc.getPropertyDesc(i);
                context.addArg(pd.getPropertyName(), pd.getValue(param), pd.getPropertyType());
            }
        }
        return context;
    }

    public static String getTableName(Class<?> entityClass, NameConverter nameConverter) {
        Table table = entityClass.getAnnotation(Table.class);
        if (table != null) {
            return table.name();
        }
        return nameConverter.entityToTable(entityClass.getName());
    }

    public static String getColumnName(EntityOperator entityOperator, Class<?> clazz, PropertyDesc pd, NameConverter nameConverter) {
        EntityOperator.ColumnInfo column = entityOperator.getColumnInfo(clazz, pd, nameConverter);
        if (column != null) {
            return column.name;
        }
        return nameConverter.propertyToColumn(pd.getPropertyName());
    }

    public static String buildSelectSQL(BeanDescFactory beanDescFactory, EntityOperator entityOperator, Class<?> clazz, NameConverter nameConverter) {
        StringBuilder sb = new StringBuilder();
        BeanDesc beanDesc = beanDescFactory.getBeanDesc(clazz);
        sb.append("SELECT * FROM ");
        sb.append(MirageUtil.getTableName(clazz, nameConverter));
        sb.append(" WHERE ");
        int count = 0;
        for (int i = 0; i < beanDesc.getPropertyDescSize(); ++i) {
            PropertyDesc pd = beanDesc.getPropertyDesc(i);
            EntityOperator.PrimaryKeyInfo primaryKey = entityOperator.getPrimaryKeyInfo(clazz, pd, nameConverter);
            if (primaryKey == null) continue;
            if (count != 0) {
                sb.append(" AND ");
            }
            sb.append(MirageUtil.getColumnName(entityOperator, clazz, pd, nameConverter));
            sb.append(" = ?");
            ++count;
        }
        if (count == 0) {
            throw new RuntimeException("Primary key is not found: " + clazz.getName());
        }
        return sb.toString();
    }

    public static String buildInsertSql(BeanDescFactory beanDescFactory, EntityOperator entityOperator, Class<?> entityType, NameConverter nameConverter, List<PropertyDesc> propDescs) {
        EntityOperator.PrimaryKeyInfo primaryKey;
        PropertyDesc pd;
        int i;
        StringBuilder sb = new StringBuilder();
        BeanDesc beanDesc = beanDescFactory.getBeanDesc(entityType);
        sb.append("INSERT INTO ").append(MirageUtil.getTableName(entityType, nameConverter)).append(" (");
        int count = 0;
        for (i = 0; i < beanDesc.getPropertyDescSize(); ++i) {
            pd = beanDesc.getPropertyDesc(i);
            primaryKey = entityOperator.getPrimaryKeyInfo(entityType, pd, nameConverter);
            if (primaryKey != null && primaryKey.generationType == PrimaryKey.GenerationType.IDENTITY || pd.isTransient() || !pd.isReadable()) continue;
            if (count != 0) {
                sb.append(", ");
            }
            sb.append(MirageUtil.getColumnName(entityOperator, entityType, pd, nameConverter));
            ++count;
        }
        sb.append(") VALUES (");
        count = 0;
        for (i = 0; i < beanDesc.getPropertyDescSize(); ++i) {
            pd = beanDesc.getPropertyDesc(i);
            primaryKey = entityOperator.getPrimaryKeyInfo(entityType, pd, nameConverter);
            if (primaryKey != null && primaryKey.generationType == PrimaryKey.GenerationType.IDENTITY || pd.isTransient() || !pd.isReadable()) continue;
            if (count != 0) {
                sb.append(", ");
            }
            sb.append("?");
            propDescs.add(pd);
            ++count;
        }
        sb.append(")");
        return sb.toString();
    }

    public static String buildUpdateSql(BeanDescFactory beanDescFactory, EntityOperator entityOperator, Class<?> entityType, NameConverter nameConverter, List<PropertyDesc> propDescs) {
        EntityOperator.PrimaryKeyInfo primaryKey;
        PropertyDesc pd;
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append("UPDATE ").append(MirageUtil.getTableName(entityType, nameConverter)).append(" SET ");
        BeanDesc beanDesc = beanDescFactory.getBeanDesc(entityType);
        int count = 0;
        for (i = 0; i < beanDesc.getPropertyDescSize(); ++i) {
            pd = beanDesc.getPropertyDesc(i);
            primaryKey = entityOperator.getPrimaryKeyInfo(entityType, pd, nameConverter);
            if (primaryKey != null || pd.isTransient() || !pd.isReadable()) continue;
            if (count != 0) {
                sb.append(", ");
            }
            sb.append(MirageUtil.getColumnName(entityOperator, entityType, pd, nameConverter)).append(" = ?");
            propDescs.add(pd);
            ++count;
        }
        sb.append(" WHERE ");
        count = 0;
        for (i = 0; i < beanDesc.getPropertyDescSize(); ++i) {
            pd = beanDesc.getPropertyDesc(i);
            primaryKey = entityOperator.getPrimaryKeyInfo(entityType, pd, nameConverter);
            if (primaryKey == null || !pd.isReadable()) continue;
            if (count != 0) {
                sb.append(" AND ");
            }
            sb.append(MirageUtil.getColumnName(entityOperator, entityType, pd, nameConverter)).append(" = ? ");
            propDescs.add(pd);
            ++count;
        }
        if (count == 0) {
            throw new RuntimeException("Primary key is not found: " + entityType.getName());
        }
        return sb.toString();
    }

    public static String buildDeleteSql(BeanDescFactory beanDescFactory, EntityOperator entityOperator, Class<?> entityType, NameConverter nameConverter, List<PropertyDesc> propDescs) {
        StringBuilder sb = new StringBuilder();
        sb.append("DELETE FROM ").append(MirageUtil.getTableName(entityType, nameConverter));
        sb.append(" WHERE ");
        boolean hasPrimaryKey = false;
        BeanDesc beanDesc = beanDescFactory.getBeanDesc(entityType);
        for (int i = 0; i < beanDesc.getPropertyDescSize(); ++i) {
            PropertyDesc pd = beanDesc.getPropertyDesc(i);
            EntityOperator.PrimaryKeyInfo primaryKey = entityOperator.getPrimaryKeyInfo(entityType, pd, nameConverter);
            if (primaryKey == null || !pd.isReadable()) continue;
            if (!propDescs.isEmpty()) {
                sb.append(" AND ");
            }
            sb.append(MirageUtil.getColumnName(entityOperator, entityType, pd, nameConverter)).append("=?");
            propDescs.add(pd);
            hasPrimaryKey = true;
        }
        if (!hasPrimaryKey) {
            throw new RuntimeException("Primary key is not found: " + entityType.getName());
        }
        return sb.toString();
    }
}

