/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.amateras.mirage.util;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import jp.sf.amateras.mirage.exception.IORuntimeException;

public class IOUtil {
    public static byte[] readStream(InputStream in) {
        byte[] byArray;
        if (in == null) {
            return null;
        }
        ByteArrayOutputStream out = null;
        try {
            out = new ByteArrayOutputStream();
            byte[] buf = new byte[8192];
            int length = 0;
            while ((length = in.read(buf)) != -1) {
                out.write(buf, 0, length);
            }
            byArray = out.toByteArray();
            Object var6_6 = null;
        }
        catch (IOException e) {
            try {
                throw new IORuntimeException(e);
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                IOUtil.closeQuietly(in);
                IOUtil.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtil.closeQuietly(in);
        IOUtil.closeQuietly(out);
        return byArray;
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(String path) {
        Properties properties;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        InputStream in = null;
        try {
            in = cl.getResourceAsStream(path);
            Properties properties2 = new Properties();
            properties2.load(in);
            properties = properties2;
            Object var6_7 = null;
        }
        catch (IOException ex) {
            Properties properties3;
            try {
                properties3 = null;
                Object var6_8 = null;
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                IOUtil.closeQuietly(in);
                throw throwable;
            }
            IOUtil.closeQuietly(in);
            return properties3;
        }
        IOUtil.closeQuietly(in);
        return properties;
    }
}

