/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.amateras.mirage.updater;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.logging.Logger;
import jp.sf.amateras.mirage.SqlManager;
import jp.sf.amateras.mirage.SqlManagerImpl;
import jp.sf.amateras.mirage.StringSqlResource;
import jp.sf.amateras.mirage.dialect.Dialect;
import jp.sf.amateras.mirage.exception.SQLRuntimeException;
import jp.sf.amateras.mirage.util.IOUtil;

public class SchemaUpdater {
    private static final Logger logger = Logger.getLogger(SchemaUpdater.class.getName());
    protected SqlManager sqlManager;
    protected String tableName = "SCHEMA_VERSION";
    protected String packageName = "META-INF";

    public void setSqlManager(SqlManager sqlManager) {
        this.sqlManager = sqlManager;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void update() {
        int currentVersion;
        logger.info("Begin automatic schema updating.");
        if (!this.existsTable()) {
            this.createTable();
        }
        int version = currentVersion = this.getCurrentVersion();
        String sql = null;
        while ((sql = this.getSql(version + 1)) != null) {
            if (sql.trim().length() != 0) {
                this.sqlManager.executeUpdate(new StringSqlResource(sql));
            }
            ++version;
        }
        if (version != currentVersion) {
            this.updateVersion(version);
            logger.info(String.format("Schema was updated to version %d.", version));
        } else {
            logger.info("There are no updates.");
        }
        logger.info("End automatic schema updating.");
    }

    protected String getSql(int version) {
        Dialect dialect = ((SqlManagerImpl)this.sqlManager).getDialect();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        InputStream in = classLoader.getResourceAsStream(String.format("%s/%s_%d.sql", this.packageName, dialect.getName().toLowerCase(), version));
        if (in == null && (in = classLoader.getResourceAsStream(String.format("%s/%d.sql", this.packageName, version))) == null) {
            return null;
        }
        byte[] buf = IOUtil.readStream(in);
        try {
            return new String(buf, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected boolean existsTable() {
        try {
            int count = this.sqlManager.getSingleResult(Integer.class, new StringSqlResource(String.format("SELECT COUNT(*) FROM %s", this.tableName)));
            return count != 0;
        }
        catch (SQLRuntimeException ex) {
            return false;
        }
    }

    protected void createTable() {
        this.sqlManager.executeUpdate(new StringSqlResource(String.format("CREATE TABLE %s (VERSION NUMERIC NOT NULL)", this.tableName)));
        this.sqlManager.executeUpdate(new StringSqlResource(String.format("INSERT INTO %s (0))", this.tableName)));
    }

    protected int getCurrentVersion() {
        return this.sqlManager.getSingleResult(Integer.class, new StringSqlResource(String.format("SELECT COUNT(*) FROM %s", this.tableName)));
    }

    protected void updateVersion(int version) {
        this.sqlManager.executeUpdate(new StringSqlResource(String.format("UPDATE %s SET VERSION=?", this.tableName)), (Object)version);
    }
}

