/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.amateras.mirage.type.enumerate;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import jp.sf.amateras.mirage.annotation.Enumerated;
import jp.sf.amateras.mirage.bean.PropertyDesc;
import jp.sf.amateras.mirage.type.ValueType;
import jp.sf.amateras.mirage.util.AnnotationUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumStringValueType
implements ValueType<Object> {
    private static Enum<? extends Object> toEnum(Class type, String name) {
        try {
            return Enum.valueOf(type, name);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Override
    public Enum<? extends Object> get(Class<? extends Object> type, CallableStatement cs, int index) throws SQLException {
        String name = cs.getString(index);
        return name == null ? null : EnumStringValueType.toEnum(type, name);
    }

    @Override
    public Enum<? extends Object> get(Class<? extends Object> type, CallableStatement cs, String parameterName) throws SQLException {
        String name = cs.getString(parameterName);
        return name == null ? null : EnumStringValueType.toEnum(type, name);
    }

    @Override
    public Enum<? extends Object> get(Class<? extends Object> type, ResultSet rs, int columnIndex) throws SQLException {
        String name = rs.getString(columnIndex);
        return name == null ? null : EnumStringValueType.toEnum(type, name);
    }

    @Override
    public Enum<? extends Object> get(Class<? extends Object> type, ResultSet rs, String columnName) throws SQLException {
        String name = rs.getString(columnName);
        return name == null ? null : EnumStringValueType.toEnum(type, name);
    }

    @Override
    public Class<? extends Object> getJavaType(int sqlType) {
        return String.class;
    }

    @Override
    public boolean isSupport(Class<?> type, PropertyDesc propertyDesc) {
        Enumerated property;
        if (!Enum.class.isAssignableFrom(type)) {
            return false;
        }
        if (propertyDesc != null && (property = propertyDesc.getAnnotation(Enumerated.class)) != null && property.value() == Enumerated.EnumType.STRING) {
            return true;
        }
        Enumerated fieldType = AnnotationUtils.findAnnotation(type, Enumerated.class);
        return fieldType != null && fieldType.value() == Enumerated.EnumType.STRING;
    }

    @Override
    public void registerOutParameter(Class<?> type, CallableStatement cs, int index) throws SQLException {
        cs.registerOutParameter(index, 12);
    }

    @Override
    public void registerOutParameter(Class<?> type, CallableStatement cs, String parameterName) throws SQLException {
        cs.registerOutParameter(parameterName, 12);
    }

    @Override
    public void set(Class<? extends Object> type, PreparedStatement stmt, Object value, int index) throws SQLException {
        if (value == null) {
            stmt.setNull(index, 12);
        } else {
            stmt.setString(index, ((Enum)value).name());
        }
    }

    @Override
    public Object getDefaultValue() {
        return null;
    }
}

