/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.amateras.mirage.type.enumerate;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import jp.sf.amateras.mirage.annotation.Enumerated;
import jp.sf.amateras.mirage.bean.PropertyDesc;
import jp.sf.amateras.mirage.type.ValueType;
import jp.sf.amateras.mirage.util.AnnotationUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumOrdinalValueType
implements ValueType<Object> {
    private static Enum<? extends Object> toEnum(Class<? extends Object> type, int ordinal) {
        Object[] values = type.getEnumConstants();
        if (values.length <= ordinal || ordinal < 0) {
            return null;
        }
        return (Enum)values[ordinal];
    }

    @Override
    public Integer get(Class<? extends Object> type, CallableStatement cs, int index) throws SQLException {
        int value = cs.getInt(index);
        if (cs.wasNull()) {
            return null;
        }
        return value;
    }

    @Override
    public Integer get(Class<? extends Object> type, CallableStatement cs, String parameterName) throws SQLException {
        int value = cs.getInt(parameterName);
        if (cs.wasNull()) {
            return null;
        }
        return value;
    }

    @Override
    public Enum<? extends Object> get(Class<? extends Object> type, ResultSet rs, int columnIndex) throws SQLException {
        int ordinal = rs.getInt(columnIndex);
        if (rs.wasNull()) {
            return null;
        }
        return EnumOrdinalValueType.toEnum(type, ordinal);
    }

    @Override
    public Enum<? extends Object> get(Class<? extends Object> type, ResultSet rs, String columnName) throws SQLException {
        int ordinal = rs.getInt(columnName);
        if (rs.wasNull()) {
            return null;
        }
        return EnumOrdinalValueType.toEnum(type, ordinal);
    }

    @Override
    public Class<? extends Object> getJavaType(int sqlType) {
        return Integer.class;
    }

    @Override
    public boolean isSupport(Class<?> type, PropertyDesc propertyDesc) {
        Enumerated property;
        if (!Enum.class.isAssignableFrom(type)) {
            return false;
        }
        if (propertyDesc != null && (property = propertyDesc.getAnnotation(Enumerated.class)) != null && property.value() == Enumerated.EnumType.ORDINAL) {
            return true;
        }
        Enumerated fieldType = AnnotationUtils.findAnnotation(type, Enumerated.class);
        return fieldType != null && fieldType.value() == Enumerated.EnumType.ORDINAL;
    }

    @Override
    public void registerOutParameter(Class<?> type, CallableStatement cs, int index) throws SQLException {
        cs.registerOutParameter(index, 4);
    }

    @Override
    public void registerOutParameter(Class<?> type, CallableStatement cs, String parameterName) throws SQLException {
        cs.registerOutParameter(parameterName, 4);
    }

    @Override
    public void set(Class<? extends Object> type, PreparedStatement stmt, Object value, int index) throws SQLException {
        if (value == null) {
            stmt.setNull(index, 4);
        } else {
            stmt.setInt(index, ((Enum)value).ordinal());
        }
    }

    @Override
    public Object getDefaultValue() {
        return null;
    }
}

