/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.amateras.mirage.type;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import jp.sf.amateras.mirage.type.AbstractValueType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LongPrimitiveValueType
extends AbstractValueType<Long> {
    public LongPrimitiveValueType() {
        super(Long.TYPE);
    }

    @Override
    public Long get(Class<? extends Long> type, ResultSet rs, int columnIndex) throws SQLException {
        return rs.getLong(columnIndex);
    }

    @Override
    public Long get(Class<? extends Long> type, ResultSet rs, String columnName) throws SQLException {
        return rs.getLong(columnName);
    }

    @Override
    public void set(Class<? extends Long> type, PreparedStatement stmt, Long value, int index) throws SQLException {
        if (value == null) {
            this.setNull(type, stmt, index);
            return;
        }
        stmt.setLong(index, value);
    }

    @Override
    public Long get(Class<? extends Long> type, CallableStatement cs, int index) throws SQLException {
        Long value = cs.getLong(index);
        if (value != null && cs.wasNull()) {
            value = null;
        }
        return value;
    }

    @Override
    public Long get(Class<? extends Long> type, CallableStatement cs, String parameterName) throws SQLException {
        Long value = cs.getLong(parameterName);
        if (value != null && cs.wasNull()) {
            value = null;
        }
        return value;
    }

    @Override
    public Long getDefaultValue() {
        return 0L;
    }
}

