/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.amateras.mirage.parser;

import java.lang.reflect.Array;
import java.util.List;
import jp.sf.amateras.mirage.parser.AbstractNode;
import jp.sf.amateras.mirage.parser.SqlContext;
import jp.sf.amateras.mirage.util.OgnlUtil;

public class ParenBindVariableNode
extends AbstractNode {
    private String expression;
    private Object parsedExpression;

    public ParenBindVariableNode(String expression) {
        this.expression = expression;
        this.parsedExpression = OgnlUtil.parseExpression(expression);
    }

    public String getExpression() {
        return this.expression;
    }

    public void accept(SqlContext ctx) {
        Object var = OgnlUtil.getValue(this.parsedExpression, ctx);
        if (var instanceof List) {
            this.bindArray(ctx, ((List)List.class.cast(var)).toArray());
        } else {
            if (var == null) {
                return;
            }
            if (var.getClass().isArray()) {
                this.bindArray(ctx, var);
            } else {
                ctx.addSql("?", var, var.getClass());
            }
        }
    }

    protected void bindArray(SqlContext ctx, Object array) {
        int length = Array.getLength(array);
        if (length == 0) {
            return;
        }
        Class<?> clazz = null;
        for (int i = 0; i < length; ++i) {
            Object o = Array.get(array, i);
            if (o == null) continue;
            clazz = o.getClass();
        }
        ctx.addSql("(");
        Object value = Array.get(array, 0);
        ctx.addSql("?", value, clazz);
        for (int i = 1; i < length; ++i) {
            ctx.addSql(", ");
            value = Array.get(array, i);
            ctx.addSql("?", value, clazz);
        }
        ctx.addSql(")");
    }

    public String toString() {
        return "ParenBindVariableNode [expression=" + this.expression + ", parsedExpression=" + this.parsedExpression + ", children=" + this.children + "]";
    }
}

