/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.amateras.mirage.parser;

import jp.sf.amateras.mirage.exception.TwoWaySQLException;
import jp.sf.amateras.mirage.parser.ContainerNode;
import jp.sf.amateras.mirage.parser.ElseNode;
import jp.sf.amateras.mirage.parser.SqlContext;
import jp.sf.amateras.mirage.util.OgnlUtil;

public class IfNode
extends ContainerNode {
    private String expression;
    private Object parsedExpression;
    private ElseNode elseNode;

    public IfNode(String expression) {
        this.expression = expression;
        this.parsedExpression = OgnlUtil.parseExpression(expression);
    }

    public String getExpression() {
        return this.expression;
    }

    public ElseNode getElseNode() {
        return this.elseNode;
    }

    public void setElseNode(ElseNode elseNode) {
        this.elseNode = elseNode;
    }

    public void accept(SqlContext ctx) {
        Object result = OgnlUtil.getValue(this.parsedExpression, ctx);
        if (result instanceof Boolean) {
            if (((Boolean)result).booleanValue()) {
                super.accept(ctx);
                ctx.setEnabled(true);
            } else if (this.elseNode != null) {
                this.elseNode.accept(ctx);
                ctx.setEnabled(true);
            }
        } else {
            throw new TwoWaySQLException(String.format("%s is not bool expression.", this.expression));
        }
    }

    public String toString() {
        return "IfNode [expression=" + this.expression + ", parsedExpression=" + this.parsedExpression + ", elseNode=" + this.elseNode + ", children=" + this.children + "]";
    }
}

