/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.amateras.mirage.parser;

import jp.sf.amateras.mirage.bean.BeanDesc;
import jp.sf.amateras.mirage.bean.BeanDescFactory;
import jp.sf.amateras.mirage.bean.PropertyDesc;
import jp.sf.amateras.mirage.exception.TwoWaySQLException;
import jp.sf.amateras.mirage.parser.AbstractNode;
import jp.sf.amateras.mirage.parser.SqlContext;
import jp.sf.amateras.mirage.util.StringUtil;

public class EmbeddedValueNode
extends AbstractNode {
    private String expression;
    private String baseName;
    private String propertyName;
    private BeanDescFactory beanDescFactory;

    public EmbeddedValueNode(String expression, BeanDescFactory beanDescFactory) {
        this.expression = expression;
        this.beanDescFactory = beanDescFactory;
        String[] array = StringUtil.split(expression, ".");
        this.baseName = array[0];
        if (array.length > 1) {
            this.propertyName = array[1];
        }
    }

    public String getExpression() {
        return this.expression;
    }

    public void accept(SqlContext ctx) {
        Object value = ctx.getArg(this.baseName);
        Class<?> clazz = ctx.getArgType(this.baseName);
        if (this.propertyName != null) {
            BeanDesc beanDesc = this.beanDescFactory.getBeanDesc(clazz);
            PropertyDesc pd = beanDesc.getPropertyDesc(this.propertyName);
            value = pd.getValue(value);
            clazz = pd.getPropertyType();
        }
        if (value != null) {
            String sql = value.toString();
            if (sql.indexOf(59) >= 0) {
                throw new TwoWaySQLException("semicolon is not allowed.");
            }
            ctx.addSql(sql);
        }
    }

    public String toString() {
        return "EmbeddedValueNode [expression=" + this.expression + ", baseName=" + this.baseName + ", propertyName=" + this.propertyName + ", children=" + this.children + "]";
    }
}

