/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.amateras.mirage.parser;

import java.util.Arrays;
import jp.sf.amateras.mirage.bean.BeanDesc;
import jp.sf.amateras.mirage.bean.BeanDescFactory;
import jp.sf.amateras.mirage.bean.PropertyDesc;
import jp.sf.amateras.mirage.parser.AbstractNode;
import jp.sf.amateras.mirage.parser.SqlContext;
import jp.sf.amateras.mirage.util.StringUtil;

public class BindVariableNode
extends AbstractNode {
    private String expression;
    private String[] names;
    private BeanDescFactory beanDescFactory;

    public BindVariableNode(String expression, BeanDescFactory beanDescFactory) {
        this.expression = expression;
        this.names = StringUtil.split(expression, ".");
        this.beanDescFactory = beanDescFactory;
    }

    public String getExpression() {
        return this.expression;
    }

    public void accept(SqlContext ctx) {
        Object value = ctx.getArg(this.names[0]);
        Class<?> clazz = ctx.getArgType(this.names[0]);
        for (int pos = 1; pos < this.names.length; ++pos) {
            BeanDesc beanDesc = this.beanDescFactory.getBeanDesc(clazz);
            PropertyDesc pd = beanDesc.getPropertyDesc(this.names[pos]);
            if (value == null) break;
            value = pd.getValue(value);
            clazz = pd.getPropertyType();
        }
        ctx.addSql("?", value, clazz);
    }

    public String toString() {
        return "BindVariableNode [expression=" + this.expression + ", names=" + Arrays.toString(this.names) + ", children=" + this.children + "]";
    }
}

