/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.amateras.mirage.integration.guice;

import java.util.logging.Logger;
import jp.sf.amateras.mirage.session.SessionFactory;
import jp.sf.amateras.mirage.util.ExceptionUtil;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class TransactionInterceptor
implements MethodInterceptor {
    private static final Logger logger = Logger.getLogger(TransactionInterceptor.class.getName());

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object ex3;
        try {
            SessionFactory.getSession().begin();
        }
        catch (Exception ex2) {
            logger.severe("Failed to begin Session.");
            logger.severe(ExceptionUtil.toString(ex2));
            throw ex2;
        }
        try {
            try {
                Object result = invocation.proceed();
                try {
                    SessionFactory.getSession().commit();
                }
                catch (Exception ex3) {
                    logger.severe("Failed to commit Session.");
                    logger.severe(ExceptionUtil.toString(ex3));
                    throw ex3;
                }
                ex3 = result;
                Object var5_8 = null;
            }
            catch (Exception ex3) {
                try {
                    SessionFactory.getSession().rollback();
                    throw ex3;
                }
                catch (Exception e) {
                    logger.severe("Failed to rollback Session.");
                    logger.severe(ExceptionUtil.toString(e));
                    throw e;
                }
            }
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            try {
                SessionFactory.getSession().release();
                throw throwable;
            }
            catch (Exception ex2) {
                logger.severe("Failed to release Session.");
                logger.severe(ExceptionUtil.toString(ex2));
                throw ex2;
            }
        }
        try {}
        catch (Exception ex2) {
            logger.severe("Failed to release Session.");
            logger.severe(ExceptionUtil.toString(ex2));
            throw ex2;
        }
        SessionFactory.getSession().release();
        return ex3;
    }
}

