/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.amateras.mirage.bean;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.LinkedHashMap;
import java.util.Map;
import jp.sf.amateras.mirage.bean.PropertyExtractor;
import jp.sf.amateras.mirage.bean.PropertyWrapper;
import jp.sf.amateras.mirage.bean.PropertyWrapperImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPropertyExtractor
implements PropertyExtractor {
    @Override
    public Map<String, PropertyWrapper> extractProperties(Class<?> clazz) {
        Field[] fields;
        PropertyExtractor.PropertyInfo info;
        Method[] methods;
        LinkedHashMap<String, PropertyExtractor.PropertyInfo> map = new LinkedHashMap<String, PropertyExtractor.PropertyInfo>();
        for (Method method : methods = clazz.getMethods()) {
            String propertyName;
            if (method.getDeclaringClass() == Object.class) continue;
            String methodName = method.getName();
            if ((methodName.startsWith("get") || methodName.startsWith("is")) && method.getParameterTypes().length == 0) {
                propertyName = DefaultPropertyExtractor.getPropertyName(methodName);
                info = (PropertyExtractor.PropertyInfo)map.get(propertyName);
                if (info == null) {
                    info = new PropertyExtractor.PropertyInfo();
                    info.name = propertyName;
                    info.getterMethod = method;
                    info.type = method.getReturnType();
                    map.put(propertyName, info);
                } else if (info.type == method.getReturnType()) {
                    info.getterMethod = method;
                }
            }
            if (!methodName.startsWith("set") || method.getParameterTypes().length != 1) continue;
            propertyName = DefaultPropertyExtractor.getPropertyName(methodName);
            info = (PropertyExtractor.PropertyInfo)map.get(propertyName);
            if (info == null) {
                info = new PropertyExtractor.PropertyInfo();
                info.name = propertyName;
                info.setterMethod = method;
                info.type = method.getParameterTypes()[0];
                map.put(propertyName, info);
                continue;
            }
            if (info.type != method.getParameterTypes()[0]) continue;
            info.setterMethod = method;
        }
        for (Field field : fields = clazz.getFields()) {
            int modifiers = field.getModifiers();
            if (map.containsKey(field.getName()) || Modifier.isStatic(modifiers) || Modifier.isFinal(modifiers)) continue;
            info = new PropertyExtractor.PropertyInfo();
            info.name = field.getName();
            info.field = field;
            info.type = field.getType();
            map.put(field.getName(), info);
        }
        LinkedHashMap<String, PropertyWrapper> result = new LinkedHashMap<String, PropertyWrapper>();
        for (Map.Entry e : map.entrySet()) {
            PropertyExtractor.PropertyInfo info2 = (PropertyExtractor.PropertyInfo)e.getValue();
            if (info2.field != null) {
                result.put((String)e.getKey(), new PropertyWrapperImpl(info2.name, null, null, info2.field));
                continue;
            }
            Field field = null;
            try {
                field = clazz.getDeclaredField(info2.name);
            }
            catch (Exception ex) {
                // empty catch block
            }
            result.put((String)e.getKey(), new PropertyWrapperImpl(info2.name, info2.getterMethod, info2.setterMethod, field));
        }
        return result;
    }

    protected static String getPropertyName(String methodName) {
        if (methodName.startsWith("get") || methodName.startsWith("set")) {
            methodName = methodName.substring(3);
        }
        if (methodName.startsWith("is")) {
            methodName = methodName.substring(2);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < methodName.length(); ++i) {
            char c = methodName.charAt(i);
            if (i == 0) {
                sb.append(String.valueOf(c).toLowerCase());
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

