/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.amateras.mirage.bean;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jp.sf.amateras.mirage.bean.BeanDesc;
import jp.sf.amateras.mirage.bean.BeanDescImpl;
import jp.sf.amateras.mirage.bean.DefaultPropertyExtractor;
import jp.sf.amateras.mirage.bean.MapBeanDescImpl;
import jp.sf.amateras.mirage.bean.PropertyExtractor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanDescFactory {
    private Map<Class<?>, BeanDesc> cacheMap = new ConcurrentHashMap();
    private boolean cacheEnabled = false;
    private PropertyExtractor propertyExtractor = new DefaultPropertyExtractor();

    public void setCacheEnabled(boolean cacheEnabled) {
        this.cacheEnabled = cacheEnabled;
    }

    public boolean isCacheEnabled() {
        return this.cacheEnabled;
    }

    public void setPropertyExtractor(PropertyExtractor propertyExtractor) {
        this.propertyExtractor = propertyExtractor;
    }

    public BeanDesc getBeanDesc(Object obj) {
        if (obj instanceof Map) {
            return new MapBeanDescImpl((Map)obj);
        }
        return this.getBeanDesc(obj.getClass());
    }

    public BeanDesc getBeanDesc(Class<?> clazz) {
        if (clazz == Map.class) {
            return new MapBeanDescImpl();
        }
        if (this.cacheEnabled && this.cacheMap.containsKey(clazz)) {
            return this.cacheMap.get(clazz);
        }
        BeanDescImpl beanDesc = new BeanDescImpl(clazz, this.propertyExtractor.extractProperties(clazz));
        if (this.cacheEnabled) {
            this.cacheMap.put(clazz, beanDesc);
        }
        return beanDesc;
    }
}

