/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.amateras.mirage;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jp.sf.amateras.mirage.CallExecutor;
import jp.sf.amateras.mirage.ClasspathSqlResource;
import jp.sf.amateras.mirage.DefaultEntityOperator;
import jp.sf.amateras.mirage.EntityOperator;
import jp.sf.amateras.mirage.IterationCallback;
import jp.sf.amateras.mirage.SqlExecutor;
import jp.sf.amateras.mirage.SqlManager;
import jp.sf.amateras.mirage.SqlResource;
import jp.sf.amateras.mirage.annotation.PrimaryKey;
import jp.sf.amateras.mirage.annotation.ResultSet;
import jp.sf.amateras.mirage.bean.BeanDesc;
import jp.sf.amateras.mirage.bean.BeanDescFactory;
import jp.sf.amateras.mirage.bean.PropertyDesc;
import jp.sf.amateras.mirage.dialect.Dialect;
import jp.sf.amateras.mirage.dialect.StandardDialect;
import jp.sf.amateras.mirage.exception.IORuntimeException;
import jp.sf.amateras.mirage.naming.DefaultNameConverter;
import jp.sf.amateras.mirage.naming.NameConverter;
import jp.sf.amateras.mirage.parser.Node;
import jp.sf.amateras.mirage.parser.SqlContext;
import jp.sf.amateras.mirage.parser.SqlParserImpl;
import jp.sf.amateras.mirage.provider.ConnectionProvider;
import jp.sf.amateras.mirage.type.BigDecimalValueType;
import jp.sf.amateras.mirage.type.BooleanPrimitiveValueType;
import jp.sf.amateras.mirage.type.BooleanValueType;
import jp.sf.amateras.mirage.type.ByteArrayValueType;
import jp.sf.amateras.mirage.type.DoublePrimitiveValueType;
import jp.sf.amateras.mirage.type.DoubleValueType;
import jp.sf.amateras.mirage.type.FloatPrimitiveValueType;
import jp.sf.amateras.mirage.type.FloatValueType;
import jp.sf.amateras.mirage.type.IntegerPrimitiveValueType;
import jp.sf.amateras.mirage.type.IntegerValueType;
import jp.sf.amateras.mirage.type.LongPrimitiveValueType;
import jp.sf.amateras.mirage.type.LongValueType;
import jp.sf.amateras.mirage.type.ShortPrimitiveValueType;
import jp.sf.amateras.mirage.type.ShortValueType;
import jp.sf.amateras.mirage.type.SqlDateValueType;
import jp.sf.amateras.mirage.type.StringValueType;
import jp.sf.amateras.mirage.type.TimeValueType;
import jp.sf.amateras.mirage.type.TimestampValueType;
import jp.sf.amateras.mirage.type.UtilDateValueType;
import jp.sf.amateras.mirage.type.ValueType;
import jp.sf.amateras.mirage.type.enumerate.EnumOneBasedOrdinalValueType;
import jp.sf.amateras.mirage.type.enumerate.EnumOrdinalValueType;
import jp.sf.amateras.mirage.type.enumerate.EnumStringValueType;
import jp.sf.amateras.mirage.util.IOUtil;
import jp.sf.amateras.mirage.util.MirageUtil;
import jp.sf.amateras.mirage.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlManagerImpl
implements SqlManager {
    protected BeanDescFactory beanDescFactory;
    protected ConnectionProvider connectionProvider;
    protected NameConverter nameConverter;
    protected EntityOperator entityOperator;
    protected Dialect dialect = new StandardDialect();
    protected SqlExecutor sqlExecutor = new SqlExecutor();
    protected CallExecutor callExecutor = new CallExecutor();
    protected Map<SqlResource, Node> nodeCache = new ConcurrentHashMap<SqlResource, Node>();
    protected boolean cacheMode = false;

    public SqlManagerImpl() {
        this.addValueType(new StringValueType());
        this.addValueType(new IntegerValueType());
        this.addValueType(new IntegerPrimitiveValueType());
        this.addValueType(new LongValueType());
        this.addValueType(new LongPrimitiveValueType());
        this.addValueType(new ShortValueType());
        this.addValueType(new ShortPrimitiveValueType());
        this.addValueType(new DoubleValueType());
        this.addValueType(new DoublePrimitiveValueType());
        this.addValueType(new FloatValueType());
        this.addValueType(new FloatPrimitiveValueType());
        this.addValueType(new BooleanValueType());
        this.addValueType(new BooleanPrimitiveValueType());
        this.addValueType(new BigDecimalValueType());
        this.addValueType(new SqlDateValueType());
        this.addValueType(new UtilDateValueType());
        this.addValueType(new TimeValueType());
        this.addValueType(new TimestampValueType());
        this.addValueType(new ByteArrayValueType());
        this.addValueType(new EnumStringValueType());
        this.addValueType(new EnumOrdinalValueType());
        this.addValueType(new EnumOneBasedOrdinalValueType());
        this.setDialect(this.dialect);
        this.setBeanDescFactory(new BeanDescFactory());
        this.setNameConverter(new DefaultNameConverter());
        this.setEntityOperator(new DefaultEntityOperator());
    }

    public void setCacheMode(boolean cacheMode) {
        this.cacheMode = cacheMode;
    }

    public void setBeanDescFactory(BeanDescFactory beanDescFactory) {
        this.beanDescFactory = beanDescFactory;
        this.sqlExecutor.setBeanDescFactory(beanDescFactory);
        this.callExecutor.setBeanDescFactory(beanDescFactory);
    }

    @Override
    public void setNameConverter(NameConverter nameConverter) {
        this.nameConverter = nameConverter;
        this.sqlExecutor.setNameConverter(nameConverter);
        this.callExecutor.setNameConverter(nameConverter);
    }

    public NameConverter getNameConverter() {
        return this.nameConverter;
    }

    @Override
    public void setConnectionProvider(ConnectionProvider connectionProvider) {
        this.connectionProvider = connectionProvider;
        this.sqlExecutor.setConnectionProvider(connectionProvider);
        this.callExecutor.setConnectionProvider(connectionProvider);
    }

    @Override
    public void setEntityOperator(EntityOperator entityOperator) {
        this.entityOperator = entityOperator;
        this.sqlExecutor.setEntityOperator(entityOperator);
        this.callExecutor.setEntityOperator(entityOperator);
    }

    public ConnectionProvider getConnectionProvider() {
        return this.connectionProvider;
    }

    @Override
    public void setDialect(Dialect dialect) {
        this.dialect = dialect;
        this.sqlExecutor.setDialect(dialect);
        this.callExecutor.setDialect(dialect);
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    protected Node prepareNode(SqlResource resource) {
        if (this.cacheMode && this.nodeCache.containsKey(resource)) {
            return this.nodeCache.get(resource);
        }
        String sql = null;
        try {
            try {
                InputStream in = resource.getInputStream();
                if (in == null) {
                    throw new RuntimeException(String.format("resource: %s is not found.", resource));
                }
                sql = new String(IOUtil.readStream(in), "UTF-8");
            }
            catch (IORuntimeException ex) {
                throw new IORuntimeException(String.format("Failed to load SQL from: %s", resource), ex.getCause());
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
            Object var5_7 = null;
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            throw throwable;
        }
        sql = sql.trim();
        if (sql.endsWith(";")) {
            sql = sql.substring(0, sql.length() - 1);
        }
        Node node = new SqlParserImpl(sql, this.beanDescFactory).parse();
        if (this.cacheMode) {
            this.nodeCache.put(resource, node);
        }
        return node;
    }

    protected SqlContext prepareSqlContext(Object param) {
        return MirageUtil.getSqlContext(this.beanDescFactory, param);
    }

    @Override
    public int executeUpdate(String sqlPath) {
        return this.executeUpdate(new ClasspathSqlResource(sqlPath));
    }

    @Override
    public int executeUpdate(SqlResource resource) {
        return this.executeUpdate(resource, null);
    }

    @Override
    public int executeUpdate(String sqlPath, Object param) {
        return this.executeUpdate(new ClasspathSqlResource(sqlPath), param);
    }

    @Override
    public int executeUpdate(SqlResource resource, Object param) {
        Node node = this.prepareNode(resource);
        SqlContext context = this.prepareSqlContext(param);
        node.accept(context);
        return this.sqlExecutor.executeUpdateSql(context.getSql(), context.getBindVariables(), null);
    }

    @Override
    public <T> List<T> getResultList(Class<T> clazz, String sqlPath) {
        return this.getResultList(clazz, new ClasspathSqlResource(sqlPath));
    }

    @Override
    public <T> List<T> getResultList(Class<T> clazz, SqlResource resource) {
        return this.getResultList(clazz, resource, null);
    }

    @Override
    public <T> List<T> getResultList(Class<T> clazz, String sqlPath, Object param) {
        return this.getResultList(clazz, new ClasspathSqlResource(sqlPath), param);
    }

    @Override
    public <T> List<T> getResultList(Class<T> clazz, SqlResource resource, Object param) {
        Node node = this.prepareNode(resource);
        SqlContext context = this.prepareSqlContext(param);
        node.accept(context);
        return this.sqlExecutor.getResultList(clazz, context.getSql(), context.getBindVariables());
    }

    @Override
    public <T> T getSingleResult(Class<T> clazz, String sqlPath) {
        return this.getSingleResult(clazz, new ClasspathSqlResource(sqlPath));
    }

    @Override
    public <T> T getSingleResult(Class<T> clazz, SqlResource resource) {
        return this.getSingleResult(clazz, resource, null);
    }

    @Override
    public <T> T getSingleResult(Class<T> clazz, String sqlPath, Object param) {
        return this.getSingleResult(clazz, new ClasspathSqlResource(sqlPath), param);
    }

    @Override
    public <T> T getSingleResult(Class<T> clazz, SqlResource resource, Object param) {
        Node node = this.prepareNode(resource);
        SqlContext context = this.prepareSqlContext(param);
        node.accept(context);
        return this.sqlExecutor.getSingleResult(clazz, context.getSql(), context.getBindVariables());
    }

    @Override
    public int deleteEntity(Object entity) {
        ArrayList<PropertyDesc> propDescs = new ArrayList<PropertyDesc>();
        String executeSql = MirageUtil.buildDeleteSql(this.beanDescFactory, this.entityOperator, entity.getClass(), this.nameConverter, propDescs);
        return this.sqlExecutor.executeUpdateSql(executeSql, propDescs.toArray(new PropertyDesc[propDescs.size()]), entity);
    }

    @Override
    public <T> int deleteBatch(T ... entities) {
        if (entities.length == 0) {
            return 0;
        }
        ArrayList<PropertyDesc[]> paramsList = new ArrayList<PropertyDesc[]>();
        String executeSql = null;
        for (T entity : entities) {
            ArrayList<PropertyDesc> propDescs = new ArrayList<PropertyDesc>();
            String sql = MirageUtil.buildDeleteSql(this.beanDescFactory, this.entityOperator, entity.getClass(), this.nameConverter, propDescs);
            if (executeSql == null) {
                executeSql = sql;
            } else if (!sql.equals(executeSql)) {
                throw new IllegalArgumentException("Different entity is contained in the entity list.");
            }
            paramsList.add(propDescs.toArray(new PropertyDesc[propDescs.size()]));
        }
        return this.sqlExecutor.executeBatchUpdateSql(executeSql, paramsList, entities);
    }

    @Override
    public <T> int deleteBatch(List<T> entities) {
        return this.deleteBatch(entities.toArray());
    }

    private void fillPrimaryKeysBySequence(Object entity) {
        if (!this.dialect.supportsGenerationType(PrimaryKey.GenerationType.SEQUENCE)) {
            return;
        }
        BeanDesc beanDesc = this.beanDescFactory.getBeanDesc(entity.getClass());
        int size = beanDesc.getPropertyDescSize();
        for (int i = 0; i < size; ++i) {
            PropertyDesc propertyDesc = beanDesc.getPropertyDesc(i);
            PrimaryKey primaryKey = propertyDesc.getAnnotation(PrimaryKey.class);
            if (primaryKey == null || primaryKey.generationType() != PrimaryKey.GenerationType.SEQUENCE) continue;
            String sql = this.dialect.getSequenceSql(primaryKey.generator());
            Object value = this.sqlExecutor.getSingleResult(propertyDesc.getPropertyType(), sql, new Object[0]);
            propertyDesc.setValue(entity, value);
        }
    }

    @Override
    public int insertEntity(Object entity) {
        this.fillPrimaryKeysBySequence(entity);
        ArrayList<PropertyDesc> propDescs = new ArrayList<PropertyDesc>();
        String sql = MirageUtil.buildInsertSql(this.beanDescFactory, this.entityOperator, entity.getClass(), this.nameConverter, propDescs);
        return this.sqlExecutor.executeUpdateSql(sql, propDescs.toArray(new PropertyDesc[propDescs.size()]), entity);
    }

    @Override
    public <T> int insertBatch(T ... entities) {
        if (entities.length == 0) {
            return 0;
        }
        ArrayList<PropertyDesc[]> propDescsList = new ArrayList<PropertyDesc[]>();
        String executeSql = null;
        for (T entity : entities) {
            this.fillPrimaryKeysBySequence(entity);
            ArrayList<PropertyDesc> propDescs = new ArrayList<PropertyDesc>();
            String sql = MirageUtil.buildInsertSql(this.beanDescFactory, this.entityOperator, entity.getClass(), this.nameConverter, propDescs);
            if (executeSql == null) {
                executeSql = sql;
            } else if (!sql.equals(executeSql)) {
                throw new IllegalArgumentException("Different entity is contained in the entity list.");
            }
            propDescsList.add(propDescs.toArray(new PropertyDesc[propDescs.size()]));
        }
        return this.sqlExecutor.executeBatchUpdateSql(executeSql, propDescsList, entities);
    }

    @Override
    public <T> int insertBatch(List<T> entities) {
        return this.insertBatch(entities.toArray());
    }

    @Override
    public int updateEntity(Object entity) {
        ArrayList<PropertyDesc> propDescs = new ArrayList<PropertyDesc>();
        String executeSql = MirageUtil.buildUpdateSql(this.beanDescFactory, this.entityOperator, entity.getClass(), this.nameConverter, propDescs);
        return this.sqlExecutor.executeUpdateSql(executeSql, propDescs.toArray(new PropertyDesc[propDescs.size()]), entity);
    }

    @Override
    public <T> int updateBatch(T ... entities) {
        if (entities.length == 0) {
            return 0;
        }
        ArrayList<PropertyDesc[]> propDescsList = new ArrayList<PropertyDesc[]>();
        String executeSql = null;
        for (T entity : entities) {
            ArrayList<PropertyDesc> propDescs = new ArrayList<PropertyDesc>();
            String sql = MirageUtil.buildUpdateSql(this.beanDescFactory, this.entityOperator, entity.getClass(), this.nameConverter, propDescs);
            if (executeSql == null) {
                executeSql = sql;
            } else if (!sql.equals(executeSql)) {
                throw new IllegalArgumentException("Different entity is contained in the entity list.");
            }
            propDescsList.add(propDescs.toArray(new PropertyDesc[propDescs.size()]));
        }
        return this.sqlExecutor.executeBatchUpdateSql(executeSql, propDescsList, entities);
    }

    @Override
    public <T> int updateBatch(List<T> entities) {
        return this.updateBatch(entities.toArray());
    }

    @Override
    public <T> T findEntity(Class<T> clazz, Object ... id) {
        String executeSql = MirageUtil.buildSelectSQL(this.beanDescFactory, this.entityOperator, clazz, this.nameConverter);
        return this.sqlExecutor.getSingleResult(clazz, executeSql, id);
    }

    public void setValueTypes(List<ValueType<?>> valueTypes) {
        Validate.noNullElements(valueTypes);
        this.sqlExecutor.setValueTypes(valueTypes);
        this.callExecutor.setValueTypes(valueTypes);
    }

    @Override
    public void addValueType(ValueType<?> valueType) {
        this.sqlExecutor.addValueType(valueType);
        this.callExecutor.addValueType(valueType);
    }

    @Override
    public int getCount(String sqlPath) {
        return this.getCount(new ClasspathSqlResource(sqlPath), null);
    }

    @Override
    public int getCount(SqlResource resource) {
        return this.getCount(resource, null);
    }

    @Override
    public int getCount(String sqlPath, Object param) {
        return this.getCount(new ClasspathSqlResource(sqlPath), param);
    }

    @Override
    public int getCount(SqlResource resource, Object param) {
        Node node = this.prepareNode(resource);
        SqlContext context = this.prepareSqlContext(param);
        node.accept(context);
        String sql = this.dialect.getCountSql(context.getSql());
        Integer result = this.sqlExecutor.getSingleResult(Integer.class, sql, context.getBindVariables());
        if (result == null) {
            return 0;
        }
        return result;
    }

    @Override
    public int getCountBySql(String sql) {
        return this.getCountBySql(sql, new Object[0]);
    }

    @Override
    public int getCountBySql(String sql, Object ... params) {
        return this.getSingleResultBySql(Integer.class, sql, params);
    }

    @Override
    public <T, R> R iterate(Class<T> clazz, IterationCallback<T, R> callback, String sqlPath) {
        return this.iterate(clazz, callback, new ClasspathSqlResource(sqlPath));
    }

    @Override
    public <T, R> R iterate(Class<T> clazz, IterationCallback<T, R> callback, SqlResource resource) {
        return this.iterate(clazz, callback, resource, null);
    }

    @Override
    public <T, R> R iterate(Class<T> clazz, IterationCallback<T, R> callback, String sqlPath, Object param) {
        return this.iterate(clazz, callback, new ClasspathSqlResource(sqlPath), param);
    }

    @Override
    public <T, R> R iterate(Class<T> clazz, IterationCallback<T, R> callback, SqlResource resource, Object param) {
        Node node = this.prepareNode(resource);
        SqlContext context = this.prepareSqlContext(param);
        node.accept(context);
        return this.sqlExecutor.iterate(clazz, callback, context.getSql(), context.getBindVariables());
    }

    @Override
    public void call(String procedureName) {
        String sql = this.toCallString(procedureName, false);
        this.callExecutor.call(sql);
    }

    @Override
    public void call(String procedureName, Object parameter) {
        String sql = this.toCallString(procedureName, parameter, false);
        this.callExecutor.call(sql, parameter);
    }

    @Override
    public <T> T call(Class<T> resultClass, String functionName) {
        String sql = this.toCallString(functionName, true);
        return this.callExecutor.call(resultClass, sql);
    }

    @Override
    public <T> T call(Class<T> resultClass, String functionName, Object param) {
        String sql = this.toCallString(functionName, param, true);
        return this.callExecutor.call(resultClass, sql, param);
    }

    @Override
    public <T> List<T> callForList(Class<T> resultClass, String functionName) {
        String sql = this.toCallString(functionName, true);
        return this.callExecutor.callForList(resultClass, sql);
    }

    @Override
    public <T> List<T> callForList(Class<T> resultClass, String functionName, Object param) {
        String sql = this.toCallString(functionName, param, true);
        return this.callExecutor.callForList(resultClass, sql, param);
    }

    protected String toCallString(String moduleName, boolean function) {
        return this.toCallString(moduleName, null, function);
    }

    protected String toCallString(String moduleName, Object param, boolean function) {
        StringBuilder sb = new StringBuilder();
        if (function) {
            sb.append("{? = call ");
        } else {
            sb.append("{call ");
        }
        sb.append(moduleName);
        sb.append("(");
        if (param != null) {
            StringBuilder p = new StringBuilder();
            BeanDesc beanDesc = this.beanDescFactory.getBeanDesc(param);
            int parameterCount = 0;
            for (int i = 0; i < beanDesc.getPropertyDescSize(); ++i) {
                PropertyDesc pd = beanDesc.getPropertyDesc(i);
                if (!this.needsParameter(pd)) continue;
                if (parameterCount > 0) {
                    p.append(", ");
                }
                if (parameterCount >= 0) {
                    p.append("?");
                }
                ++parameterCount;
            }
            sb.append(p.toString());
        }
        sb.append(")");
        sb.append("}");
        return sb.toString();
    }

    protected boolean needsParameter(PropertyDesc pd) {
        ResultSet resultSet = pd.getAnnotation(ResultSet.class);
        if (resultSet != null) {
            return this.dialect.needsParameterForResultSet();
        }
        return true;
    }

    @Override
    public <T> List<T> getResultListBySql(Class<T> clazz, String sql) {
        return this.getResultListBySql(clazz, sql, new Object[0]);
    }

    @Override
    public <T> List<T> getResultListBySql(Class<T> clazz, String sql, Object ... params) {
        return this.sqlExecutor.getResultList(clazz, sql, params);
    }

    @Override
    public <T> T getSingleResultBySql(Class<T> clazz, String sql) {
        return this.getSingleResultBySql(clazz, sql, new Object[0]);
    }

    @Override
    public <T> T getSingleResultBySql(Class<T> clazz, String sql, Object ... params) {
        return this.sqlExecutor.getSingleResult(clazz, sql, params);
    }

    @Override
    public <T, R> R iterateBySql(Class<T> clazz, IterationCallback<T, R> callback, String sql) {
        return this.iterateBySql(clazz, callback, sql, new Object[0]);
    }

    @Override
    public <T, R> R iterateBySql(Class<T> clazz, IterationCallback<T, R> callback, String sql, Object ... params) {
        return this.sqlExecutor.iterate(clazz, callback, sql, params);
    }

    @Override
    public int executeUpdateBySql(String sql) {
        return this.executeUpdateBySql(sql, new Object[0]);
    }

    @Override
    public int executeUpdateBySql(String sql, Object ... params) {
        return this.sqlExecutor.executeUpdateSql(sql, params, null);
    }
}

