/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.amateras.mirage;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jp.sf.amateras.mirage.EntityOperator;
import jp.sf.amateras.mirage.IterationCallback;
import jp.sf.amateras.mirage.annotation.PrimaryKey;
import jp.sf.amateras.mirage.bean.BeanDesc;
import jp.sf.amateras.mirage.bean.BeanDescFactory;
import jp.sf.amateras.mirage.bean.PropertyDesc;
import jp.sf.amateras.mirage.dialect.Dialect;
import jp.sf.amateras.mirage.exception.BreakIterationException;
import jp.sf.amateras.mirage.exception.SQLRuntimeException;
import jp.sf.amateras.mirage.naming.NameConverter;
import jp.sf.amateras.mirage.provider.ConnectionProvider;
import jp.sf.amateras.mirage.type.ValueType;
import jp.sf.amateras.mirage.util.JdbcUtil;
import jp.sf.amateras.mirage.util.MirageUtil;
import jp.sf.amateras.mirage.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlExecutor {
    private static final Logger logger = Logger.getLogger(SqlExecutor.class.getName());
    private BeanDescFactory beanDescFactory;
    private NameConverter nameConverter;
    private ConnectionProvider connectionProvider;
    private Dialect dialect;
    private List<ValueType<?>> valueTypes = new ArrayList();
    private EntityOperator entityOreator;

    public void setBeanDescFactory(BeanDescFactory beanDescFactory) {
        this.beanDescFactory = beanDescFactory;
    }

    protected BeanDescFactory getBeanDescFactory() {
        return this.beanDescFactory;
    }

    public void setConnectionProvider(ConnectionProvider connectionProvider) {
        this.connectionProvider = connectionProvider;
    }

    public void setNameConverter(NameConverter nameConverter) {
        this.nameConverter = nameConverter;
    }

    public void setValueTypes(List<ValueType<?>> valueTypes) {
        Validate.notNull(valueTypes);
        this.valueTypes = valueTypes;
    }

    public void addValueType(ValueType<?> valueType) {
        this.valueTypes.add(valueType);
    }

    public void setDialect(Dialect dialect) {
        this.dialect = dialect;
    }

    public void setEntityOperator(EntityOperator entityOreator) {
        this.entityOreator = entityOreator;
    }

    private static void printSql(String sql) {
        sql = sql.replace("\r\n", "\n");
        sql = sql.replace("\r", "\n");
        StringBuilder sb = new StringBuilder();
        for (String line : sql.split("\n")) {
            if (line.trim().length() == 0) continue;
            sb.append(line).append(System.getProperty("line.separator"));
        }
        logger.info(sb.toString().trim());
    }

    private static void printParameters(PropertyDesc[] propDescs, Object entity) {
        if (propDescs == null) {
            return;
        }
        for (int i = 0; i < propDescs.length; ++i) {
            logger.info(String.format("params[%d]=%s", i, propDescs[i].getValue(entity)));
        }
    }

    private static void printParameters(Object[] params) {
        if (params == null) {
            return;
        }
        for (int i = 0; i < params.length; ++i) {
            logger.info(String.format("params[%d]=%s", i, params[i]));
        }
    }

    public <T> List<T> getResultList(Class<T> clazz, String sql, Object[] params) {
        ArrayList<T> arrayList;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.connectionProvider.getConnection().prepareStatement(sql);
            this.setParameters(stmt, params);
            ArrayList<T> list = new ArrayList<T>();
            if (logger.isLoggable(Level.INFO)) {
                SqlExecutor.printSql(sql);
                SqlExecutor.printParameters(params);
            }
            rs = stmt.executeQuery();
            ResultSetMetaData meta = rs.getMetaData();
            int columnCount = meta.getColumnCount();
            BeanDesc beanDesc = this.beanDescFactory.getBeanDesc(clazz);
            while (rs.next()) {
                T entity = this.entityOreator.createEntity(clazz, rs, meta, columnCount, beanDesc, this.dialect, this.valueTypes, this.nameConverter);
                list.add(entity);
            }
            arrayList = list;
            Object var12_12 = null;
        }
        catch (SQLException ex) {
            try {
                throw new SQLRuntimeException(ex);
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                JdbcUtil.close(rs);
                JdbcUtil.close(stmt);
                throw throwable;
            }
        }
        JdbcUtil.close(rs);
        JdbcUtil.close(stmt);
        return arrayList;
    }

    public <T, R> R iterate(Class<T> clazz, IterationCallback<T, R> callback, String sql, Object[] params) {
        R r;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.connectionProvider.getConnection().prepareStatement(sql);
            this.setParameters(stmt, params);
            if (logger.isLoggable(Level.INFO)) {
                SqlExecutor.printSql(sql);
                SqlExecutor.printParameters(params);
            }
            rs = stmt.executeQuery();
            ResultSetMetaData meta = rs.getMetaData();
            int columnCount = meta.getColumnCount();
            BeanDesc beanDesc = this.beanDescFactory.getBeanDesc(clazz);
            R result = null;
            while (rs.next()) {
                T entity = this.entityOreator.createEntity(clazz, rs, meta, columnCount, beanDesc, this.dialect, this.valueTypes, this.nameConverter);
                try {
                    result = callback.iterate(entity);
                }
                catch (BreakIterationException ex) {
                    break;
                }
            }
            r = result;
            Object var14_14 = null;
        }
        catch (SQLException ex) {
            try {
                throw new SQLRuntimeException(ex);
            }
            catch (Throwable throwable) {
                Object var14_15 = null;
                JdbcUtil.close(rs);
                JdbcUtil.close(stmt);
                throw throwable;
            }
        }
        JdbcUtil.close(rs);
        JdbcUtil.close(stmt);
        return r;
    }

    public <T> T getSingleResult(Class<T> clazz, String sql, Object[] params) {
        T t;
        ResultSet rs;
        PreparedStatement stmt;
        block6: {
            T entity;
            stmt = null;
            rs = null;
            stmt = this.connectionProvider.getConnection().prepareStatement(sql);
            this.setParameters(stmt, params);
            if (logger.isLoggable(Level.INFO)) {
                SqlExecutor.printSql(sql);
                SqlExecutor.printParameters(params);
            }
            rs = stmt.executeQuery();
            ResultSetMetaData meta = rs.getMetaData();
            int columnCount = meta.getColumnCount();
            BeanDesc beanDesc = this.beanDescFactory.getBeanDesc(clazz);
            if (!rs.next()) break block6;
            T t2 = entity = this.entityOreator.createEntity(clazz, rs, meta, columnCount, beanDesc, this.dialect, this.valueTypes, this.nameConverter);
            Object var12_13 = null;
            JdbcUtil.close(rs);
            JdbcUtil.close(stmt);
            return t2;
        }
        try {
            t = null;
            Object var12_14 = null;
        }
        catch (SQLException ex) {
            try {
                throw new SQLRuntimeException(ex);
            }
            catch (Throwable throwable) {
                Object var12_15 = null;
                JdbcUtil.close(rs);
                JdbcUtil.close(stmt);
                throw throwable;
            }
        }
        JdbcUtil.close(rs);
        JdbcUtil.close(stmt);
        return t;
    }

    public int executeUpdateSql(String sql, PropertyDesc[] propDescs, Object entity) {
        int n;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            Connection conn = this.connectionProvider.getConnection();
            if (logger.isLoggable(Level.INFO)) {
                SqlExecutor.printSql(sql);
                SqlExecutor.printParameters(propDescs);
            }
            stmt = entity != null && this.dialect.supportsGenerationType(PrimaryKey.GenerationType.IDENTITY) ? conn.prepareStatement(sql, 1) : conn.prepareStatement(sql);
            this.setParameters(stmt, propDescs, entity);
            int result = stmt.executeUpdate();
            if (entity != null && this.dialect.supportsGenerationType(PrimaryKey.GenerationType.IDENTITY)) {
                rs = stmt.getGeneratedKeys();
                this.fillIdentityPrimaryKeys(entity, rs);
            }
            n = result;
            Object var10_10 = null;
        }
        catch (SQLException ex) {
            try {
                throw new SQLRuntimeException(ex);
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                JdbcUtil.close(rs);
                JdbcUtil.close(stmt);
                throw throwable;
            }
        }
        JdbcUtil.close(rs);
        JdbcUtil.close(stmt);
        return n;
    }

    public int executeUpdateSql(String sql, Object[] params, Object entity) {
        int n;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            Connection conn = this.connectionProvider.getConnection();
            if (logger.isLoggable(Level.INFO)) {
                SqlExecutor.printSql(sql);
                SqlExecutor.printParameters(params);
            }
            stmt = entity != null && this.dialect.supportsGenerationType(PrimaryKey.GenerationType.IDENTITY) ? conn.prepareStatement(sql, 1) : conn.prepareStatement(sql);
            this.setParameters(stmt, params);
            int result = stmt.executeUpdate();
            if (entity != null && this.dialect.supportsGenerationType(PrimaryKey.GenerationType.IDENTITY)) {
                rs = stmt.getGeneratedKeys();
                this.fillIdentityPrimaryKeys(entity, rs);
            }
            n = result;
            Object var10_10 = null;
        }
        catch (SQLException ex) {
            try {
                throw new SQLRuntimeException(ex);
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                JdbcUtil.close(rs);
                JdbcUtil.close(stmt);
                throw throwable;
            }
        }
        JdbcUtil.close(rs);
        JdbcUtil.close(stmt);
        return n;
    }

    public int executeBatchUpdateSql(String sql, List<PropertyDesc[]> propDescsList, Object[] entities) {
        int n;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            int i;
            Connection conn = this.connectionProvider.getConnection();
            if (logger.isLoggable(Level.INFO)) {
                SqlExecutor.printSql(sql);
                for (i = 0; i < propDescsList.size(); ++i) {
                    PropertyDesc[] propDescs2 = propDescsList.get(i);
                    logger.info("[" + i + "]");
                    SqlExecutor.printParameters(propDescs2, entities[i]);
                }
            }
            stmt = entities != null && this.dialect.supportsGenerationType(PrimaryKey.GenerationType.IDENTITY) ? conn.prepareStatement(sql, 1) : conn.prepareStatement(sql);
            if (entities != null) {
                for (i = 0; i < propDescsList.size(); ++i) {
                    PropertyDesc[] propDescs = propDescsList.get(i);
                    this.setParameters(stmt, propDescs, entities[i]);
                    stmt.addBatch();
                }
            } else {
                for (PropertyDesc[] propDescs : propDescsList) {
                    this.setParameters(stmt, propDescs, null);
                    stmt.addBatch();
                }
            }
            int[] results = stmt.executeBatch();
            int updateRows = 0;
            for (int result : results) {
                updateRows += result;
            }
            if (entities != null && this.dialect.supportsGenerationType(PrimaryKey.GenerationType.IDENTITY)) {
                rs = stmt.getGeneratedKeys();
                for (Object entity : entities) {
                    this.fillIdentityPrimaryKeys(entity, rs);
                }
            }
            n = updateRows;
            Object var14_21 = null;
        }
        catch (SQLException ex) {
            try {
                throw new SQLRuntimeException(ex);
            }
            catch (Throwable throwable) {
                Object var14_22 = null;
                JdbcUtil.close(rs);
                JdbcUtil.close(stmt);
                throw throwable;
            }
        }
        JdbcUtil.close(rs);
        JdbcUtil.close(stmt);
        return n;
    }

    protected void fillIdentityPrimaryKeys(Object entity, ResultSet rs) throws SQLException {
        BeanDesc beanDesc = this.beanDescFactory.getBeanDesc(entity.getClass());
        int size = beanDesc.getPropertyDescSize();
        for (int i = 0; i < size; ++i) {
            Class<?> propertyType;
            ValueType<?> valueType;
            PropertyDesc propertyDesc = beanDesc.getPropertyDesc(i);
            PrimaryKey primaryKey = propertyDesc.getAnnotation(PrimaryKey.class);
            if (primaryKey == null || primaryKey.generationType() != PrimaryKey.GenerationType.IDENTITY || !rs.next() || (valueType = MirageUtil.getValueType(propertyType = propertyDesc.getPropertyType(), propertyDesc, this.dialect, this.valueTypes)) == null) continue;
            propertyDesc.setValue(entity, valueType.get(propertyType, rs, 1));
        }
    }

    protected void setParameters(PreparedStatement stmt, PropertyDesc[] propDescs, Object entity) throws SQLException {
        for (int i = 0; i < propDescs.length; ++i) {
            PropertyDesc propertyDesc = propDescs[i];
            if (propertyDesc == null) {
                stmt.setObject(i + 1, null);
                continue;
            }
            Class<?> propertType = propertyDesc.getPropertyType();
            ValueType<?> valueType = MirageUtil.getValueType(propertType, propertyDesc, this.dialect, this.valueTypes);
            if (valueType != null) {
                valueType.set(propertType, stmt, propertyDesc.getValue(entity), i + 1);
                continue;
            }
            if (!logger.isLoggable(Level.INFO)) continue;
            logger.warning("valueType for " + propertType.getName() + " not found.");
        }
    }

    protected void setParameters(PreparedStatement stmt, Object[] params) throws SQLException {
        for (int i = 0; i < params.length; ++i) {
            if (params[i] == null) {
                stmt.setObject(i + 1, null);
                continue;
            }
            Class<?> propertType = params[i].getClass();
            ValueType<?> valueType = MirageUtil.getValueType(propertType, null, this.dialect, this.valueTypes);
            if (valueType != null) {
                valueType.set(propertType, stmt, params[i], i + 1);
                continue;
            }
            if (!logger.isLoggable(Level.INFO)) continue;
            logger.warning("valueType for " + propertType.getName() + " not found.");
        }
    }
}

