/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.amateras.mirage;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jp.sf.amateras.mirage.EntityCreationFailedException;
import jp.sf.amateras.mirage.EntityOperator;
import jp.sf.amateras.mirage.annotation.Column;
import jp.sf.amateras.mirage.annotation.PrimaryKey;
import jp.sf.amateras.mirage.bean.BeanDesc;
import jp.sf.amateras.mirage.bean.PropertyDesc;
import jp.sf.amateras.mirage.dialect.Dialect;
import jp.sf.amateras.mirage.naming.NameConverter;
import jp.sf.amateras.mirage.type.ValueType;
import jp.sf.amateras.mirage.util.MirageUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultEntityOperator
implements EntityOperator {
    private static final Logger logger = Logger.getLogger(DefaultEntityOperator.class.getName());

    @Override
    public <T> T createEntity(Class<T> entityType, ResultSet rs, ResultSetMetaData meta, int columnCount, BeanDesc beanDesc, Dialect dialect, List<ValueType<?>> valueTypes, NameConverter nameConverter) {
        try {
            ValueType<?> valueType = MirageUtil.getValueType(entityType, null, dialect, valueTypes);
            if (valueType != null) {
                return (T)valueType.get(entityType, rs, 1);
            }
            HashMap entity = null;
            if (entityType == Map.class) {
                entity = new HashMap();
            } else {
                Constructor<?>[] constructors;
                for (Constructor<?> constructor : constructors = entityType.getDeclaredConstructors()) {
                    try {
                        constructor.setAccessible(true);
                        Class<?>[] types = constructor.getParameterTypes();
                        Object[] params = new Object[types.length];
                        for (int i = 0; i < params.length; ++i) {
                            ValueType<?> valueType2 = MirageUtil.getValueType(types[i], null, dialect, valueTypes);
                            if (valueType2 == null) continue;
                            params[i] = valueType2.getDefaultValue();
                        }
                        entity = constructor.newInstance(params);
                    }
                    catch (InstantiationException e) {
                    }
                    catch (IllegalAccessException e) {
                    }
                    catch (IllegalArgumentException e) {
                    }
                    catch (InvocationTargetException e) {
                        // empty catch block
                    }
                }
            }
            if (entity == null) {
                throw new EntityCreationFailedException();
            }
            for (int i = 0; i < columnCount; ++i) {
                Column column;
                PropertyDesc property;
                int j;
                String columnLabel = meta.getColumnLabel(i + 1);
                String columnName = meta.getColumnName(i + 1);
                PropertyDesc pd = null;
                for (j = 0; j < beanDesc.getPropertyDescSize(); ++j) {
                    property = beanDesc.getPropertyDesc(j);
                    column = property.getAnnotation(Column.class);
                    if (column == null || !columnLabel.equalsIgnoreCase(column.name())) continue;
                    pd = property;
                    break;
                }
                if (pd == null) {
                    for (j = 0; j < beanDesc.getPropertyDescSize(); ++j) {
                        property = beanDesc.getPropertyDesc(j);
                        column = property.getAnnotation(Column.class);
                        if (column == null || !columnName.equalsIgnoreCase(column.name())) continue;
                        pd = property;
                        break;
                    }
                }
                if (pd == null) {
                    String propertyName = nameConverter.columnToProperty(columnLabel);
                    pd = beanDesc.getPropertyDesc(propertyName);
                }
                if (pd == null) {
                    String propertyName = nameConverter.columnToProperty(columnName);
                    pd = beanDesc.getPropertyDesc(propertyName);
                }
                if (pd != null) {
                    Class<?> propertyType = pd.getPropertyType();
                    ValueType<?> valueType3 = MirageUtil.getValueType(propertyType, pd, dialect, valueTypes);
                    if (valueType3 != null) {
                        pd.setValue(entity, valueType3.get(propertyType, rs, columnLabel));
                        continue;
                    }
                    if (!logger.isLoggable(Level.FINE)) continue;
                    logger.fine(String.format("column [%s] is ignored because property [%s]'s type is not supported: %s", columnLabel, pd.getPropertyName(), propertyType.getName()));
                    continue;
                }
                if (!logger.isLoggable(Level.FINER)) continue;
                logger.finer(String.format("column [%s] is ignored because property is not found in the bean", columnLabel));
            }
            return (T)entity;
        }
        catch (SQLException e) {
            throw new EntityCreationFailedException(e);
        }
        catch (SecurityException e) {
            throw new EntityCreationFailedException(e);
        }
        catch (IllegalArgumentException e) {
            throw new EntityCreationFailedException(e);
        }
    }

    @Override
    public EntityOperator.PrimaryKeyInfo getPrimaryKeyInfo(Class<?> clazz, PropertyDesc propertyDesc, NameConverter nameConverter) {
        PrimaryKey primaryKey = propertyDesc.getAnnotation(PrimaryKey.class);
        if (primaryKey == null) {
            return null;
        }
        return new EntityOperator.PrimaryKeyInfo(primaryKey.generationType(), primaryKey.generator());
    }

    @Override
    public EntityOperator.ColumnInfo getColumnInfo(Class<?> clazz, PropertyDesc propertyDesc, NameConverter nameConverter) {
        Column column = propertyDesc.getAnnotation(Column.class);
        if (column == null) {
            return null;
        }
        return new EntityOperator.ColumnInfo(column.name());
    }
}

