/*
 * Decompiled with CFR 0.152.
 */
package jakarta.activation;

import jakarta.activation.CommandObject;
import jakarta.activation.DataHandler;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class CommandInfo {
    private String verb;
    private String className;

    public CommandInfo(String verb, String className) {
        this.verb = verb;
        this.className = className;
    }

    public String getCommandName() {
        return this.verb;
    }

    public String getCommandClass() {
        return this.className;
    }

    public Object getCommandObject(DataHandler dh, ClassLoader loader) throws IOException, ClassNotFoundException {
        Object new_bean = null;
        new_bean = Beans.instantiate(loader, this.className);
        if (new_bean != null) {
            InputStream is;
            if (new_bean instanceof CommandObject) {
                ((CommandObject)new_bean).setCommandContext(this.verb, dh);
            } else if (new_bean instanceof Externalizable && dh != null && (is = dh.getInputStream()) != null) {
                ((Externalizable)new_bean).readExternal(new ObjectInputStream(is));
            }
        }
        return new_bean;
    }

    private static final class Beans {
        static final Method instantiateMethod;

        private Beans() {
        }

        static Object instantiate(ClassLoader loader, String cn) throws IOException, ClassNotFoundException {
            block8: {
                if (instantiateMethod != null) {
                    try {
                        return instantiateMethod.invoke(null, loader, cn);
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        ReflectiveOperationException exception = e;
                        break block8;
                    }
                }
                if (loader == null) {
                    try {
                        loader = ClassLoader.getSystemClassLoader();
                    }
                    catch (SecurityException e) {
                        // empty catch block
                    }
                }
                Class<?> beanClass = Class.forName(cn, true, loader);
                try {
                    return beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception ex) {
                    throw new ClassNotFoundException(beanClass + ": " + ex, ex);
                }
            }
            return null;
        }

        static {
            Method m;
            try {
                Class<?> c = Class.forName("java.beans.Beans");
                m = c.getDeclaredMethod("instantiate", ClassLoader.class, String.class);
            }
            catch (ClassNotFoundException | NoSuchMethodException e) {
                m = null;
            }
            instantiateMethod = m;
        }
    }
}

