/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.sux4j.util;

import it.unimi.dsi.bits.BitVector;
import it.unimi.dsi.bits.LongArrayBitVector;
import it.unimi.dsi.fastutil.bytes.ByteIterable;
import it.unimi.dsi.fastutil.bytes.ByteIterator;
import it.unimi.dsi.fastutil.ints.IntIterable;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.longs.LongIterable;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongIterators;
import it.unimi.dsi.fastutil.shorts.ShortIterable;
import it.unimi.dsi.fastutil.shorts.ShortIterator;
import it.unimi.dsi.sux4j.util.EliasFanoMonotoneLongBigList;
import java.util.NoSuchElementException;

public class EliasFanoPrefixSumLongBigList
extends EliasFanoMonotoneLongBigList {
    private static final long serialVersionUID = 2L;
    private final BitVector upperBits;

    public EliasFanoPrefixSumLongBigList(LongIterable elements) {
        super(new CumulativeLongIterable(elements));
        this.upperBits = this.selectUpper.bitVector();
    }

    public EliasFanoPrefixSumLongBigList(IntIterable elements) {
        this(() -> LongIterators.wrap((IntIterator)elements.iterator()));
    }

    public EliasFanoPrefixSumLongBigList(ShortIterable elements) {
        this(() -> LongIterators.wrap((ShortIterator)elements.iterator()));
    }

    public EliasFanoPrefixSumLongBigList(ByteIterable elements) {
        this(() -> LongIterators.wrap((ByteIterator)elements.iterator()));
    }

    private static final long getDiff(long[] bits, long index, int l) {
        if (l == 0) {
            return 0L;
        }
        int m = 64 - l;
        long start = index * (long)l;
        int startWord = LongArrayBitVector.word((long)start);
        int startBit = LongArrayBitVector.bit((long)start);
        long a = startBit <= m ? bits[startWord] << m - startBit >>> m : bits[startWord] >>> startBit | bits[startWord + 1] << m - startBit >>> m;
        startWord = LongArrayBitVector.word((long)(start += (long)l));
        startBit = LongArrayBitVector.bit((long)start);
        return (startBit <= m ? bits[startWord] << m - startBit >>> m : bits[startWord] >>> startBit | bits[startWord + 1] << m - startBit >>> m) - a;
    }

    @Override
    public long getLong(long index) {
        if (index < 0L || index >= this.length - 1L) {
            throw new IndexOutOfBoundsException(Long.toString(index));
        }
        long pos = this.selectUpper.select(index + 1L);
        if (this.upperBits.getBoolean(pos - 1L)) {
            return EliasFanoPrefixSumLongBigList.getDiff(this.lowerBits, index, this.l);
        }
        return (pos - this.upperBits.previousOne(pos) - 1L) * (1L << this.l) + EliasFanoPrefixSumLongBigList.getDiff(this.lowerBits, index, this.l);
    }

    public long prefixSum(long index) {
        return super.getLong(index);
    }

    @Override
    public long size64() {
        return this.length - 1L;
    }

    private static final class CumulativeLongIterable
    implements LongIterable {
        private final LongIterable iterable;

        public CumulativeLongIterable(LongIterable iterable) {
            this.iterable = iterable;
        }

        public LongIterator iterator() {
            return new LongIterator(){
                private final LongIterator iterator;
                private long prefixSum;
                private boolean lastToDo;
                {
                    this.iterator = iterable.iterator();
                    this.prefixSum = 0L;
                    this.lastToDo = true;
                }

                public boolean hasNext() {
                    return this.iterator.hasNext() || this.lastToDo;
                }

                public long nextLong() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    if (!this.iterator.hasNext() && this.lastToDo) {
                        this.lastToDo = false;
                        return this.prefixSum;
                    }
                    long result = this.prefixSum;
                    this.prefixSum += this.iterator.nextLong();
                    return result;
                }
            };
        }
    }
}

