/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.sux4j.util;

import it.unimi.dsi.bits.LongArrayBitVector;
import it.unimi.dsi.fastutil.bytes.ByteIterable;
import it.unimi.dsi.fastutil.bytes.ByteIterator;
import it.unimi.dsi.fastutil.ints.IntIterable;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.longs.LongIterable;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.shorts.ShortIterable;
import it.unimi.dsi.fastutil.shorts.ShortIterator;
import it.unimi.dsi.sux4j.bits.SimpleSelect;
import it.unimi.dsi.sux4j.bits.SimpleSelectZero;
import it.unimi.dsi.sux4j.util.EliasFanoMonotoneLongBigList;
import java.io.Serializable;

public class EliasFanoIndexedMonotoneLongBigList
extends EliasFanoMonotoneLongBigList
implements Serializable {
    private static final long serialVersionUID = 0L;
    protected final SimpleSelectZero selectUpperZero;
    protected final long[] upperBits;
    private long currentIndex;
    private final long lastElement;
    private final long firstElement;

    public EliasFanoIndexedMonotoneLongBigList(ByteIterable list) {
        super(list);
        this.selectUpperZero = new SimpleSelectZero(this.selectUpper.bitVector());
        this.upperBits = this.selectUpper.bitVector().bits();
        this.currentIndex = -1L;
        this.lastElement = this.isEmpty() ? -1L : this.getLong(this.size64() - 1L);
        this.firstElement = this.isEmpty() ? Long.MAX_VALUE : this.getLong(0L);
    }

    public EliasFanoIndexedMonotoneLongBigList(IntIterable list) {
        super(list);
        this.selectUpperZero = new SimpleSelectZero(this.selectUpper.bitVector());
        this.upperBits = this.selectUpper.bitVector().bits();
        this.currentIndex = -1L;
        this.lastElement = this.isEmpty() ? -1L : this.getLong(this.size64() - 1L);
        this.firstElement = this.isEmpty() ? Long.MAX_VALUE : this.getLong(0L);
    }

    public EliasFanoIndexedMonotoneLongBigList(long length, int l, long[] lowerBits, SimpleSelect selectUpper) {
        super(length, l, lowerBits, selectUpper);
        this.selectUpperZero = new SimpleSelectZero(this.selectUpper.bitVector());
        this.upperBits = this.selectUpper.bitVector().bits();
        this.currentIndex = -1L;
        this.lastElement = this.isEmpty() ? -1L : this.getLong(this.size64() - 1L);
        this.firstElement = this.isEmpty() ? Long.MAX_VALUE : this.getLong(0L);
    }

    public EliasFanoIndexedMonotoneLongBigList(long n, long upperBound, ByteIterator iterator) {
        super(n, upperBound, iterator);
        this.selectUpperZero = new SimpleSelectZero(this.selectUpper.bitVector());
        this.upperBits = this.selectUpper.bitVector().bits();
        this.currentIndex = -1L;
        this.lastElement = this.isEmpty() ? -1L : this.getLong(this.size64() - 1L);
        this.firstElement = this.isEmpty() ? Long.MAX_VALUE : this.getLong(0L);
    }

    public EliasFanoIndexedMonotoneLongBigList(long n, long upperBound, IntIterator iterator) {
        super(n, upperBound, iterator);
        this.selectUpperZero = new SimpleSelectZero(this.selectUpper.bitVector());
        this.upperBits = this.selectUpper.bitVector().bits();
        this.currentIndex = -1L;
        this.lastElement = this.isEmpty() ? -1L : this.getLong(this.size64() - 1L);
        this.firstElement = this.isEmpty() ? Long.MAX_VALUE : this.getLong(0L);
    }

    public EliasFanoIndexedMonotoneLongBigList(long n, long upperBound, LongIterator iterator) {
        super(n, upperBound, iterator);
        this.selectUpperZero = new SimpleSelectZero(this.selectUpper.bitVector());
        this.upperBits = this.selectUpper.bitVector().bits();
        this.currentIndex = -1L;
        this.lastElement = this.isEmpty() ? -1L : this.getLong(this.size64() - 1L);
        this.firstElement = this.isEmpty() ? Long.MAX_VALUE : this.getLong(0L);
    }

    public EliasFanoIndexedMonotoneLongBigList(long n, long upperBound, ShortIterator iterator) {
        super(n, upperBound, iterator);
        this.selectUpperZero = new SimpleSelectZero(this.selectUpper.bitVector());
        this.upperBits = this.selectUpper.bitVector().bits();
        this.currentIndex = -1L;
        this.lastElement = this.isEmpty() ? -1L : this.getLong(this.size64() - 1L);
        this.firstElement = this.isEmpty() ? Long.MAX_VALUE : this.getLong(0L);
    }

    public EliasFanoIndexedMonotoneLongBigList(long[] a, LongIterator iterator) {
        super(a, iterator);
        this.selectUpperZero = new SimpleSelectZero(this.selectUpper.bitVector());
        this.upperBits = this.selectUpper.bitVector().bits();
        this.currentIndex = -1L;
        this.lastElement = this.isEmpty() ? -1L : this.getLong(this.size64() - 1L);
        this.firstElement = this.isEmpty() ? Long.MAX_VALUE : this.getLong(0L);
    }

    public EliasFanoIndexedMonotoneLongBigList(LongIterable list) {
        super(list);
        this.selectUpperZero = new SimpleSelectZero(this.selectUpper.bitVector());
        this.upperBits = this.selectUpper.bitVector().bits();
        this.currentIndex = -1L;
        this.lastElement = this.isEmpty() ? -1L : this.getLong(this.size64() - 1L);
        this.firstElement = this.isEmpty() ? Long.MAX_VALUE : this.getLong(0L);
    }

    public EliasFanoIndexedMonotoneLongBigList(ShortIterable list) {
        super(list);
        this.selectUpperZero = new SimpleSelectZero(this.selectUpper.bitVector());
        this.upperBits = this.selectUpper.bitVector().bits();
        this.currentIndex = -1L;
        this.lastElement = this.isEmpty() ? -1L : this.getLong(this.size64() - 1L);
        this.firstElement = this.isEmpty() ? Long.MAX_VALUE : this.getLong(0L);
    }

    public long successor(long lowerBound) {
        if (lowerBound > this.lastElement) {
            return Long.MAX_VALUE;
        }
        long zeroesToSkip = lowerBound >>> this.l;
        long position = zeroesToSkip == 0L ? 0L : this.selectUpperZero.selectZero(zeroesToSkip - 1L);
        int curr = LongArrayBitVector.word((long)position);
        long window = this.upperBits[curr];
        window &= -1L << (int)position;
        long l = this.currentIndex = zeroesToSkip == 0L ? 0L : position - zeroesToSkip + 1L;
        if (this.l == 0) {
            while (true) {
                if (window == 0L) {
                    window = this.upperBits[++curr];
                    continue;
                }
                long upperBits = LongArrayBitVector.bits((int)curr) + (long)Long.numberOfTrailingZeros(window) - this.currentIndex;
                if (upperBits >= lowerBound) {
                    return upperBits;
                }
                window &= window - 1L;
                ++this.currentIndex;
            }
        }
        long lowerBitsOffset = this.currentIndex * (long)this.l;
        int m = 64 - this.l;
        while (true) {
            if (window == 0L) {
                window = this.upperBits[++curr];
                continue;
            }
            long upperBits = LongArrayBitVector.bits((int)curr) + (long)Long.numberOfTrailingZeros(window) - this.currentIndex;
            int startWord = LongArrayBitVector.word((long)lowerBitsOffset);
            int startBit = LongArrayBitVector.bit((long)lowerBitsOffset);
            long lower = this.lowerBits[startWord] >>> startBit;
            long v = upperBits << this.l | (startBit <= m ? lower : lower | this.lowerBits[startWord + 1] << -startBit) & this.lowerBitsMask;
            if (v >= lowerBound) {
                return v;
            }
            window &= window - 1L;
            ++this.currentIndex;
            lowerBitsOffset += (long)this.l;
        }
    }

    public long strictSuccessor(long lowerBound) {
        if (lowerBound >= this.lastElement) {
            return Long.MAX_VALUE;
        }
        long zeroesToSkip = lowerBound >>> this.l;
        long position = zeroesToSkip == 0L ? 0L : this.selectUpperZero.selectZero(zeroesToSkip - 1L);
        int curr = LongArrayBitVector.word((long)position);
        long window = this.upperBits[curr];
        window &= -1L << (int)position;
        long l = this.currentIndex = zeroesToSkip == 0L ? 0L : position - zeroesToSkip + 1L;
        if (this.l == 0) {
            while (true) {
                if (window == 0L) {
                    window = this.upperBits[++curr];
                    continue;
                }
                long upperBits = LongArrayBitVector.bits((int)curr) + (long)Long.numberOfTrailingZeros(window) - this.currentIndex;
                if (upperBits > lowerBound) {
                    return upperBits;
                }
                window &= window - 1L;
                ++this.currentIndex;
            }
        }
        long lowerBitsOffset = this.currentIndex * (long)this.l;
        int m = 64 - this.l;
        while (true) {
            if (window == 0L) {
                window = this.upperBits[++curr];
                continue;
            }
            long upperBits = LongArrayBitVector.bits((int)curr) + (long)Long.numberOfTrailingZeros(window) - this.currentIndex;
            int startWord = LongArrayBitVector.word((long)lowerBitsOffset);
            int startBit = LongArrayBitVector.bit((long)lowerBitsOffset);
            long lower = this.lowerBits[startWord] >>> startBit;
            long v = upperBits << this.l | (startBit <= m ? lower : lower | this.lowerBits[startWord + 1] << -startBit) & this.lowerBitsMask;
            if (v > lowerBound) {
                return v;
            }
            window &= window - 1L;
            ++this.currentIndex;
            lowerBitsOffset += (long)this.l;
        }
    }

    public long predecessor(long upperBound) {
        long lower;
        if (upperBound <= this.firstElement) {
            return -1L;
        }
        if (upperBound > this.lastElement) {
            this.currentIndex = this.length - 1L;
            return this.lastElement;
        }
        long zeroesToSkip = upperBound >>> this.l;
        long position = this.selectUpperZero.selectZero(zeroesToSkip) - 1L;
        long rank = position - zeroesToSkip;
        if (this.l == 0) {
            while ((this.upperBits[LongArrayBitVector.word((long)position)] & 1L << (int)position) != 0L) {
                --position;
                --rank;
            }
            this.currentIndex = rank;
            return this.selectUpper.select(rank) - rank;
        }
        long lowerBitsOffset = rank * (long)this.l;
        long upperBoundLowerBits = upperBound & this.lowerBitsMask;
        int m = 64 - this.l;
        while (true) {
            int startWord = LongArrayBitVector.word((long)lowerBitsOffset);
            int startBit = LongArrayBitVector.bit((long)lowerBitsOffset);
            lower = this.lowerBits[startWord] >>> startBit;
            if (startBit > m) {
                lower |= this.lowerBits[startWord + 1] << -startBit;
            }
            if ((this.upperBits[LongArrayBitVector.word((long)position)] & 1L << (int)position) == 0L || (lower &= this.lowerBitsMask) < upperBoundLowerBits) break;
            lowerBitsOffset -= (long)this.l;
            --position;
            --rank;
        }
        this.currentIndex = rank;
        return this.selectUpper.select(rank) - rank << this.l | lower;
    }

    public long weakPredecessor(long upperBound) {
        long lower;
        if (upperBound < this.firstElement) {
            return -1L;
        }
        if (upperBound >= this.lastElement) {
            this.currentIndex = this.length - 1L;
            return this.lastElement;
        }
        long zeroesToSkip = upperBound >>> this.l;
        long position = this.selectUpperZero.selectZero(zeroesToSkip) - 1L;
        long rank = position - zeroesToSkip;
        if (this.l == 0) {
            this.currentIndex = rank;
            return this.selectUpper.select(rank) - rank;
        }
        long lowerBitsOffset = rank * (long)this.l;
        long upperBoundLowerBits = upperBound & this.lowerBitsMask;
        int m = 64 - this.l;
        while (true) {
            int startWord = LongArrayBitVector.word((long)lowerBitsOffset);
            int startBit = LongArrayBitVector.bit((long)lowerBitsOffset);
            lower = this.lowerBits[startWord] >>> startBit;
            if (startBit > m) {
                lower |= this.lowerBits[startWord + 1] << -startBit;
            }
            if ((this.upperBits[LongArrayBitVector.word((long)position)] & 1L << (int)position) == 0L || (lower &= this.lowerBitsMask) <= upperBoundLowerBits) break;
            --rank;
            lowerBitsOffset -= (long)this.l;
            --position;
        }
        this.currentIndex = rank;
        return this.selectUpper.select(rank) - rank << this.l | lower;
    }

    public long indexOf(long x) {
        if (this.successor(x) == x) {
            return this.currentIndex;
        }
        return -1L;
    }

    public boolean contains(long x) {
        return this.successor(x) == x;
    }

    public long index() {
        return this.currentIndex;
    }
}

