/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.sux4j.test;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import com.martiansoftware.jsap.stringparsers.ForNameStringParser;
import it.unimi.dsi.bits.BitVector;
import it.unimi.dsi.bits.LongArrayBitVector;
import it.unimi.dsi.bits.TransformationStrategies;
import it.unimi.dsi.bits.TransformationStrategy;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.io.FastBufferedReader;
import it.unimi.dsi.io.LineIterator;
import it.unimi.dsi.sux4j.util.ZFastTrie;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.zip.GZIPInputStream;

public class ZFastTrieSpeedTest {
    public static void main(String[] arg) throws NoSuchMethodException, IOException, JSAPException, ClassNotFoundException {
        SimpleJSAP jsap = new SimpleJSAP(ZFastTrieSpeedTest.class.getName(), "Tests the speed of a z-fast trie.", new Parameter[]{new FlaggedOption("encoding", (StringParser)ForNameStringParser.getParser(Charset.class), "UTF-8", false, 'e', "encoding", "The term file encoding."), new Switch("iso", 'i', "iso", "Use ISO-8859-1 coding internally (i.e., just use the lower eight bits of each character)."), new Switch("bitVector", 'b', "bit-vector", "Test a trie of bit vectors, rather than a trie of strings."), new Switch("zipped", 'z', "zipped", "The term list is compressed in gzip format."), new FlaggedOption("n", (StringParser)JSAP.INTSIZE_PARSER, "100000", false, 'n', "n", "The number of elements to test."), new FlaggedOption("times", (StringParser)JSAP.INTSIZE_PARSER, "10", false, 't', "times", "The number of times the set must be repeated."), new UnflaggedOption("trie", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The filename for the serialised z-fast trie."), new UnflaggedOption("stringFile", (StringParser)JSAP.STRING_PARSER, "-", false, false, "The name of a file containing a newline-separated list of strings, or - for standard input.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        String trieName = jsapResult.getString("trie");
        String stringFile = jsapResult.getString("stringFile");
        Charset encoding = (Charset)jsapResult.getObject("encoding");
        boolean zipped = jsapResult.getBoolean("zipped");
        boolean iso = jsapResult.getBoolean("iso");
        boolean bitVector = jsapResult.getBoolean("bitVector");
        int n = jsapResult.getInt("n");
        int times = jsapResult.getInt("times");
        System.out.println("Loading trie...");
        ZFastTrie zFastTrie = (ZFastTrie)BinIO.loadObject((CharSequence)trieName);
        InputStream inputStream = "-".equals(stringFile) ? System.in : new FileInputStream(stringFile);
        LineIterator lineIterator = new LineIterator(new FastBufferedReader((Reader)new InputStreamReader(zipped ? new GZIPInputStream(inputStream) : inputStream, encoding)));
        int inc = zFastTrie.size() / n;
        if (bitVector) {
            TransformationStrategy transformationStrategy = iso ? TransformationStrategies.prefixFreeIso() : TransformationStrategies.prefixFreeUtf16();
            LongArrayBitVector[] test = new LongArrayBitVector[n];
            System.out.println("Preparing strings...");
            for (int j = 0; j < n; ++j) {
                test[j] = LongArrayBitVector.copy((BitVector)transformationStrategy.toBitVector((Object)lineIterator.next()));
                if (inc <= 1) continue;
                int k = inc - 1;
                while (k-- != 0) {
                    lineIterator.next();
                }
            }
            Collections.shuffle(Arrays.asList(test));
            System.out.println("Testing...");
            int k = times;
            while (k-- != 0) {
                long time = -System.currentTimeMillis();
                int j = n;
                while (j-- != 0) {
                    zFastTrie.contains(test[j]);
                    if (j % 10000 != 0) continue;
                    System.err.print('.');
                }
                System.err.println();
                System.err.println((double)(time += System.currentTimeMillis()) / 1000.0 + "s, " + (double)time * 1000000.0 / (double)n + " ns/vector");
            }
        } else {
            String[] test = new String[n];
            System.out.println("Preparing strings...");
            for (int j = 0; j < n; ++j) {
                test[j] = lineIterator.next().toString();
                if (inc <= 1) continue;
                int k = inc - 1;
                while (k-- != 0) {
                    lineIterator.next();
                }
            }
            Collections.shuffle(Arrays.asList(test));
            System.out.println("Testing...");
            int k = times;
            while (k-- != 0) {
                long time = -System.currentTimeMillis();
                int j = n;
                while (j-- != 0) {
                    zFastTrie.contains(test[j]);
                    if (j % 10000 != 0) continue;
                    System.err.print('.');
                }
                System.err.println();
                System.err.println((double)(time += System.currentTimeMillis()) / 1000.0 + "s, " + (double)time * 1000000.0 / (double)n + " ns/vector");
            }
        }
    }
}

