/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.sux4j.test;

import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.dsi.bits.Fast;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueStats {
    public static final Logger LOGGER = LoggerFactory.getLogger(ValueStats.class);

    public static void main(String[] arg) throws JSAPException, IOException {
        SimpleJSAP jsap = new SimpleJSAP(ValueStats.class.getName(), "Prints statistical data about a binary list of longs.", new Parameter[]{new UnflaggedOption("input", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The input file.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        String input = jsapResult.getString("input");
        long max = Long.MIN_VALUE;
        long min = Long.MAX_VALUE;
        long tot = 0L;
        Long2LongOpenHashMap freqs = new Long2LongOpenHashMap();
        LongIterator i = BinIO.asLongIterator((CharSequence)input);
        while (i.hasNext()) {
            long x = i.nextLong();
            max = Math.max(max, x);
            min = Math.min(min, x);
            freqs.addTo(x, 1L);
            ++tot;
        }
        System.out.println("Min: " + min);
        System.out.println("Max: " + max);
        double entropy = 0.0;
        LongIterator iterator = freqs.values().iterator();
        while (iterator.hasNext()) {
            double p = (double)iterator.nextLong() / (double)tot;
            entropy += -p * Fast.log2((double)p);
        }
        System.out.println("Entropy: " + entropy);
    }
}

