/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.sux4j.test;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongIterable;
import it.unimi.dsi.sux4j.scratch.EliasFanoMonotoneLongBigListTables;
import it.unimi.dsi.sux4j.util.EliasFanoLongBigList;
import it.unimi.dsi.sux4j.util.EliasFanoMonotoneLongBigList;
import it.unimi.dsi.sux4j.util.EliasFanoPrefixSumLongBigList;
import it.unimi.dsi.sux4j.util.TwoSizesLongBigList;
import it.unimi.dsi.util.XoRoShiRo128PlusRandomGenerator;

public class TwoSizesLongBigListSpeedTest {
    public static void main(String[] arg) throws JSAPException {
        SimpleJSAP jsap = new SimpleJSAP(TwoSizesLongBigListSpeedTest.class.getName(), "Tests the speed of rank/select implementations.", new Parameter[]{new UnflaggedOption("numElements", (StringParser)JSAP.INTSIZE_PARSER, "1Mi", false, false, "The number of elements."), new UnflaggedOption("density", (StringParser)JSAP.DOUBLE_PARSER, ".5", false, false, "The density."), new FlaggedOption("numPos", (StringParser)JSAP.INTSIZE_PARSER, "1Mi", false, 'p', "positions", "The number of positions to test")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        int numElements = jsapResult.getInt("numElements");
        double density = jsapResult.getDouble("density");
        int numPos = jsapResult.getInt("numPos");
        XoRoShiRo128PlusRandomGenerator random = new XoRoShiRo128PlusRandomGenerator(0L);
        LongArrayList list = new LongArrayList(numElements);
        long i = numElements;
        while (i-- != 0L) {
            list.add(random.nextDouble() < density ? 0L : 100L);
        }
        int[] position = new int[numPos];
        int i2 = numPos;
        while (i2-- != 0) {
            position[i2] = (random.nextInt() & Integer.MAX_VALUE) % numElements;
        }
        TwoSizesLongBigList twoSizes = new TwoSizesLongBigList((LongIterable)list);
        EliasFanoLongBigList eliasFano = new EliasFanoLongBigList((LongIterable)list);
        EliasFanoPrefixSumLongBigList eliasFanoPrefixSum = new EliasFanoPrefixSumLongBigList((LongIterable)list);
        long[] elements = list.elements();
        for (int i3 = 1; i3 < list.size(); ++i3) {
            int n = i3;
            elements[n] = elements[n] + elements[i3 - 1];
        }
        EliasFanoMonotoneLongBigList monotone = new EliasFanoMonotoneLongBigList((LongIterable)list);
        EliasFanoMonotoneLongBigListTables tables = new EliasFanoMonotoneLongBigListTables((LongIterable)list);
        int k = 10;
        while (k-- != 0) {
            int i4;
            System.out.println("=== LongArrayList === (" + (long)list.size() * 64L + " bits)");
            long time = -System.nanoTime();
            for (i4 = 0; i4 < numPos; ++i4) {
                list.getLong(position[i4]);
            }
            System.err.println((double)(time += System.nanoTime()) / 1.0E9 + "s, " + (double)time / (double)numPos + " ns/get");
            System.out.println("=== TwoSizesLongBigList === (" + twoSizes.numBits() + " bits)");
            time = -System.nanoTime();
            for (i4 = 0; i4 < numPos; ++i4) {
                twoSizes.getLong(position[i4]);
            }
            System.err.println((double)(time += System.nanoTime()) / 1.0E9 + "s, " + (double)time / (double)numPos + " ns/get");
            System.out.println("=== EliasFanoPrefixSumLongBigList === (" + eliasFanoPrefixSum.numBits() + " bits)");
            time = -System.nanoTime();
            for (i4 = 0; i4 < numPos; ++i4) {
                eliasFanoPrefixSum.getLong(position[i4]);
            }
            System.err.println((double)(time += System.nanoTime()) / 1.0E9 + "s, " + (double)time / (double)numPos + " ns/get");
            System.out.println("=== EliasFanoLongBigList === (" + eliasFano.numBits() + " bits)");
            time = -System.nanoTime();
            for (i4 = 0; i4 < numPos; ++i4) {
                eliasFano.getLong(position[i4]);
            }
            System.err.println((double)(time += System.nanoTime()) / 1.0E9 + "s, " + (double)time / (double)numPos + " ns/get");
            System.out.println("=== EliasFanoMonotoneLongBigListTables === (" + tables.numBits() + " bits)");
            time = -System.nanoTime();
            for (i4 = 0; i4 < numPos; ++i4) {
                tables.getLong(position[i4]);
            }
            System.err.println((double)(time += System.nanoTime()) / 1.0E9 + "s, " + (double)time / (double)numPos + " ns/get");
            System.out.println("=== EliasFanoMonotoneLongBigList === (" + monotone.numBits() + " bits)");
            time = -System.nanoTime();
            for (i4 = 0; i4 < numPos; ++i4) {
                monotone.getLong(position[i4]);
            }
            System.err.println((double)(time += System.nanoTime()) / 1.0E9 + "s, " + (double)time / (double)numPos + " ns/get");
        }
    }
}

