/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.sux4j.test;

import it.unimi.dsi.bits.BitVector;
import it.unimi.dsi.bits.LongArrayBitVector;
import it.unimi.dsi.compression.Decoder;
import it.unimi.dsi.compression.TreeDecoder;
import it.unimi.dsi.fastutil.booleans.BooleanIterator;
import it.unimi.dsi.io.InputBitStream;
import it.unimi.dsi.sux4j.bits.JacobsonBalancedParentheses;
import java.io.IOException;
import java.io.Serializable;

public class SuccinctTreeDecoder
implements Decoder,
Serializable {
    private static final long serialVersionUID = 1L;
    private final JacobsonBalancedParentheses balParen;
    private final LongArrayBitVector bitVector;
    private final boolean returnZero;

    public SuccinctTreeDecoder(TreeDecoder treeDecoder) {
        this.bitVector = treeDecoder.succinctRepresentation();
        this.returnZero = this.bitVector.length() <= 2L;
        this.balParen = new JacobsonBalancedParentheses((BitVector)this.bitVector, false, true, false);
    }

    public int decode(BooleanIterator iterator) {
        if (this.returnZero) {
            return 0;
        }
        int p = 1;
        int index = 0;
        while (true) {
            if (iterator.nextBoolean()) {
                int q = (int)(this.balParen.findClose(p) + 1L);
                index += (q - p) / 2;
                if (!this.bitVector.getBoolean(q)) {
                    return index;
                }
                p = q;
                continue;
            }
            if (!this.bitVector.getBoolean(++p)) break;
        }
        return index;
    }

    public int decode(InputBitStream ibs) throws IOException {
        if (this.returnZero) {
            return 0;
        }
        int p = 1;
        int index = 0;
        while (true) {
            if (ibs.readBit() != 0) {
                int q = (int)(this.balParen.findClose(p) + 1L);
                index += (q - p) / 2;
                if (!this.bitVector.getBoolean(q)) {
                    return index;
                }
                p = q;
                continue;
            }
            if (!this.bitVector.getBoolean(++p)) break;
        }
        return index;
    }
}

