/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.sux4j.test;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.dsi.bits.BitVector;
import it.unimi.dsi.bits.LongArrayBitVector;
import it.unimi.dsi.sux4j.bits.Rank11;
import it.unimi.dsi.sux4j.bits.Rank12;
import it.unimi.dsi.sux4j.bits.Rank16;
import it.unimi.dsi.sux4j.bits.Rank9;
import it.unimi.dsi.sux4j.scratch.Rank11Original;
import it.unimi.dsi.sux4j.scratch.Rank9GogPetri;
import it.unimi.dsi.util.XoRoShiRo128PlusRandomGenerator;

public class RankSpeedTest {
    public static void main(String[] arg) throws JSAPException {
        SimpleJSAP jsap = new SimpleJSAP(RankSpeedTest.class.getName(), "Tests the speed of rank/select implementations.", new Parameter[]{new UnflaggedOption("numBits", (StringParser)JSAP.LONGSIZE_PARSER, "1Mi", false, false, "The number of bits."), new UnflaggedOption("density", (StringParser)JSAP.DOUBLE_PARSER, ".5", false, false, "The density."), new FlaggedOption("numPos", (StringParser)JSAP.INTSIZE_PARSER, "1Mi", false, 'p', "positions", "The number of positions to test")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        long numBits = jsapResult.getLong("numBits");
        double density = jsapResult.getDouble("density");
        int numPos = jsapResult.getInt("numPos");
        XoRoShiRo128PlusRandomGenerator random = new XoRoShiRo128PlusRandomGenerator(42L);
        LongArrayBitVector bitVector = LongArrayBitVector.getInstance().length(numBits);
        long i = numBits;
        while (i-- != 0L) {
            if (!(random.nextDouble() < density)) continue;
            bitVector.set(i);
        }
        long[] rankPosition = new long[numPos];
        int i2 = numPos;
        while (i2-- != 0) {
            rankPosition[i2] = (random.nextLong() & Long.MAX_VALUE) % numBits;
        }
        int k = 10;
        while (k-- != 0) {
            System.out.println("=== Rank 9 ===");
            Rank9 rank9 = new Rank9((BitVector)bitVector);
            long time = -System.nanoTime();
            for (int i3 = 0; i3 < numPos; ++i3) {
                rank9.rank(rankPosition[i3]);
            }
            System.err.println((double)(time += System.nanoTime()) / 1.0E9 + "s, " + (double)time / (double)numPos + " ns/rank (" + 100.0 * (double)rank9.numBits() / (double)numBits + "%)");
            System.out.println("=== Rank 9b ===");
            Rank9GogPetri rank9b = new Rank9GogPetri((BitVector)bitVector);
            time = -System.nanoTime();
            for (int i4 = 0; i4 < numPos; ++i4) {
                rank9b.rank(rankPosition[i4]);
            }
            System.err.println((double)(time += System.nanoTime()) / 1.0E9 + "s, " + (double)time / (double)numPos + " ns/rank (" + 100.0 * (double)rank9b.numBits() / (double)numBits + "%)");
            System.out.println("=== Rank 16 ===");
            Rank16 rank16 = new Rank16((BitVector)bitVector);
            time = -System.nanoTime();
            for (int i5 = 0; i5 < numPos; ++i5) {
                rank16.rank(rankPosition[i5]);
            }
            System.err.println((double)(time += System.nanoTime()) / 1.0E9 + "s, " + (double)time / (double)numPos + " ns/rank (" + 100.0 * (double)rank16.numBits() / (double)numBits + "%)");
            System.out.println("=== Rank 11 ===");
            Rank11Original rank11 = new Rank11Original((BitVector)bitVector);
            time = -System.nanoTime();
            for (int i6 = 0; i6 < numPos; ++i6) {
                rank11.rank(rankPosition[i6]);
            }
            System.err.println((double)(time += System.nanoTime()) / 1.0E9 + "s, " + (double)time / (double)numPos + " ns/rank (" + 100.0 * (double)rank11.numBits() / (double)numBits + "%)");
            System.out.println("=== Rank 11b ===");
            Rank11 rank11b = new Rank11((BitVector)bitVector);
            time = -System.nanoTime();
            for (int i7 = 0; i7 < numPos; ++i7) {
                rank11b.rank(rankPosition[i7]);
            }
            System.err.println((double)(time += System.nanoTime()) / 1.0E9 + "s, " + (double)time / (double)numPos + " ns/rank (" + 100.0 * (double)rank11b.numBits() / (double)numBits + "%)");
            System.out.println("=== Rank 12 ===");
            Rank12 rank12 = new Rank12((BitVector)bitVector);
            time = -System.nanoTime();
            for (int i8 = 0; i8 < numPos; ++i8) {
                rank12.rank(rankPosition[i8]);
            }
            System.err.println((double)(time += System.nanoTime()) / 1.0E9 + "s, " + (double)time / (double)numPos + " ns/rank (" + 100.0 * (double)rank12.numBits() / (double)numBits + "%)");
        }
    }
}

