/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.sux4j.test;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.dsi.bits.BitVector;
import it.unimi.dsi.bits.LongArrayBitVector;
import it.unimi.dsi.sux4j.bits.HintedBsearchSelect;
import it.unimi.dsi.sux4j.bits.Rank16;
import it.unimi.dsi.sux4j.bits.Rank9;
import it.unimi.dsi.sux4j.bits.Select9;
import it.unimi.dsi.sux4j.bits.SimpleSelect;
import it.unimi.dsi.sux4j.bits.SparseSelect;
import it.unimi.dsi.util.XoRoShiRo128PlusRandomGenerator;

public class RankSelectSpeedTest {
    public static void main(String[] arg) throws JSAPException {
        SimpleJSAP jsap = new SimpleJSAP(RankSelectSpeedTest.class.getName(), "Tests the speed of rank/select implementations.", new Parameter[]{new UnflaggedOption("numBits", (StringParser)JSAP.LONGSIZE_PARSER, "1Mi", false, false, "The number of bits."), new UnflaggedOption("density", (StringParser)JSAP.DOUBLE_PARSER, ".5", false, false, "The density."), new FlaggedOption("numPos", (StringParser)JSAP.INTSIZE_PARSER, "1Mi", false, 'p', "positions", "The number of positions to test")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        long numBits = jsapResult.getLong("numBits");
        double density = jsapResult.getDouble("density");
        int numPos = jsapResult.getInt("numPos");
        XoRoShiRo128PlusRandomGenerator random = new XoRoShiRo128PlusRandomGenerator(42L);
        LongArrayBitVector bitVector = LongArrayBitVector.getInstance().length(numBits);
        long c = 0L;
        long i = numBits;
        while (i-- != 0L) {
            if (!(random.nextDouble() < density)) continue;
            bitVector.set(i);
            ++c;
        }
        long[] rankPosition = new long[numPos];
        long[] selectPosition = new long[numPos];
        int i2 = numPos;
        while (i2-- != 0) {
            rankPosition[i2] = (random.nextLong() & Long.MAX_VALUE) % numBits;
            selectPosition[i2] = (random.nextLong() & Long.MAX_VALUE) % c;
        }
        int k = 10;
        while (k-- != 0) {
            System.out.println("=== Rank 9 ===");
            Rank9 rank9 = new Rank9((BitVector)bitVector);
            long time = -System.currentTimeMillis();
            for (int i3 = 0; i3 < numPos; ++i3) {
                rank9.rank(rankPosition[i3]);
            }
            System.err.println((double)(time += System.currentTimeMillis()) / 1000.0 + "s, " + (double)time * 1000000.0 / (double)numPos + " ns/rank");
            System.out.println("=== Rank 16 ===");
            Rank16 rank16 = new Rank16((BitVector)bitVector);
            time = -System.currentTimeMillis();
            for (int i4 = 0; i4 < numPos; ++i4) {
                rank16.rank(rankPosition[i4]);
            }
            System.err.println((double)(time += System.currentTimeMillis()) / 1000.0 + "s, " + (double)time * 1000000.0 / (double)numPos + " ns/rank");
            System.out.println("=== Hinted bsearch ===");
            HintedBsearchSelect hintedBsearchSelect = new HintedBsearchSelect(rank9);
            time = -System.currentTimeMillis();
            for (int i5 = 0; i5 < numPos; ++i5) {
                hintedBsearchSelect.select(selectPosition[i5]);
            }
            System.err.println((double)(time += System.currentTimeMillis()) / 1000.0 + "s, " + (double)time * 1000000.0 / (double)numPos + " ns/select");
            System.out.println("=== Select9 ===");
            Select9 select9 = new Select9(rank9);
            time = -System.currentTimeMillis();
            for (int i6 = 0; i6 < numPos; ++i6) {
                select9.select(selectPosition[i6]);
            }
            System.err.println((double)(time += System.currentTimeMillis()) / 1000.0 + "s, " + (double)time * 1000000.0 / (double)numPos + " ns/select");
            System.out.println("=== Simple ===");
            SimpleSelect simpleSelect = new SimpleSelect((BitVector)bitVector);
            time = -System.currentTimeMillis();
            for (int i7 = 0; i7 < numPos; ++i7) {
                simpleSelect.select(selectPosition[i7]);
            }
            System.err.println((double)(time += System.currentTimeMillis()) / 1000.0 + "s, " + (double)time * 1000000.0 / (double)numPos + " ns/select");
            System.out.println("=== Sparse ===");
            SparseSelect sparseSelect = new SparseSelect((BitVector)bitVector);
            time = -System.currentTimeMillis();
            for (int i8 = 0; i8 < numPos; ++i8) {
                sparseSelect.select(selectPosition[i8]);
            }
            System.err.println((double)(time += System.currentTimeMillis()) / 1000.0 + "s, " + (double)time * 1000000.0 / (double)numPos + " ns/select");
        }
    }
}

