/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.sux4j.test;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.dsi.Util;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import it.unimi.dsi.fastutil.objects.Object2LongFunction;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;

public class LongFunctionSpeedTest {
    private static final int NUM_WARMUPS = 4;
    private static final int NUM_SAMPLES = 11;

    public static void main(String[] arg) throws IOException, JSAPException, ClassNotFoundException {
        SimpleJSAP jsap = new SimpleJSAP(LongFunctionSpeedTest.class.getName(), "Tests the speed of a function on longs. Sequential tests (the default) read keys from disk, whereas random tests cache keys in a contiguous region of memory. Performs a few warmup repetitions, and then the median of a sample is printed on standard output. The detailed results are logged to standard error.", new Parameter[]{new Switch("random", 'r', "random", "Test a subset of longs cached contiguously in memory."), new Switch("shuffle", 'S', "shuffle", "Shuffle the subset of longs used for random tests."), new FlaggedOption("n", (StringParser)JSAP.INTSIZE_PARSER, "1000000", false, 'n', "number-of-longs", "The (maximum) number of longs used for random testing."), new Switch("check", 'c', "check", "Check that each long in the list is mapped to its ordinal position."), new UnflaggedOption("function", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The filename for the serialised function."), new UnflaggedOption("longFile", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "Read longs in binary format from this file.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        String functionName = jsapResult.getString("function");
        String longFile = jsapResult.getString("longFile");
        boolean check = jsapResult.getBoolean("check");
        boolean shuffle = jsapResult.getBoolean("shuffle");
        boolean random = jsapResult.getBoolean("random");
        int maxStrings = jsapResult.getInt("n");
        if (check && random) {
            throw new IllegalArgumentException("You cannot perform checks in random tests");
        }
        if (shuffle && !random) {
            throw new IllegalArgumentException("You can shuffle random tests only");
        }
        if (jsapResult.userSpecified("n") && !random) {
            throw new IllegalArgumentException("The number of string is meaningful for random tests only");
        }
        Object2LongFunction function = (Object2LongFunction)BinIO.loadObject((CharSequence)functionName);
        LongArrayList lines = LongArrayList.wrap((long[])BinIO.loadLongs((CharSequence)longFile));
        long size = lines.size();
        if (random) {
            int n = (int)Math.min((long)maxStrings, size);
            long[] test = new long[n];
            int step = (int)(size / (long)n) - 1;
            LongListIterator iterator = lines.iterator();
            for (int i = 0; i < n; ++i) {
                test[i] = iterator.nextLong();
                int j = step;
                while (j-- != 0) {
                    iterator.nextLong();
                }
            }
            if (shuffle) {
                Collections.shuffle(Arrays.asList(new long[][]{test}));
            }
            System.gc();
            System.gc();
            long t = -1L;
            long[] sample = new long[11];
            System.err.println("Warmup...");
            int k = 15;
            while (k-- != 0) {
                long time = -System.nanoTime();
                for (int i = 0; i < n; ++i) {
                    t ^= function.getLong((Object)test[i]);
                    if ((i & 0xFFFFF) != 0) continue;
                    System.err.print('.');
                }
                System.err.println();
                time += System.nanoTime();
                if (k < 11) {
                    sample[k] = time;
                }
                System.err.println(Util.format((double)((double)time / 1.0E9)) + "s, " + Util.format((double)((double)time / (double)n)) + " ns/item");
                if (k != 11) continue;
                System.err.println("Sampling " + n + " longs...");
            }
            System.out.println("Median: " + Util.format((double)((double)sample[5] / 1.0E9)) + "s, " + Util.format((double)((double)sample[5] / (double)n)) + " ns/item");
            if (t == 0L) {
                System.err.println(t);
            }
        } else {
            System.gc();
            System.gc();
            long t = -1L;
            long[] sample = new long[11];
            System.err.println("Warmup...");
            int k = 15;
            while (k-- != 0) {
                LongListIterator iterator = lines.iterator();
                long time = -System.nanoTime();
                for (long i = 0L; i < size; ++i) {
                    long index = function.getLong(iterator.next());
                    t ^= index;
                    if (check && index != i) {
                        throw new AssertionError((Object)(index + " != " + i));
                    }
                    if ((i & 0xFFFFFL) != 0L) continue;
                    System.err.print('.');
                }
                System.err.println();
                time += System.nanoTime();
                if (k < 11) {
                    sample[k] = time;
                }
                System.err.println(Util.format((double)((double)time / 1.0E9)) + "s, " + Util.format((double)((double)time / (double)size)) + " ns/item");
                if (k != 11) continue;
                System.err.println("Scanning " + size + " longs...");
            }
            System.out.println("Median: " + Util.format((double)((double)sample[5] / 1.0E9)) + "s, " + Util.format((double)((double)sample[5] / (double)size)) + " ns/item");
            if (t == 0L) {
                System.err.println(t);
            }
        }
    }
}

