/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.sux4j.test;

import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.dsi.Util;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.longs.LongList;
import java.io.IOException;

public class ListSpeedTest {
    public static void main(String[] arg) throws IOException, JSAPException, ClassNotFoundException {
        SimpleJSAP jsap = new SimpleJSAP(ListSpeedTest.class.getName(), "Test the speed of a list", new Parameter[]{new Switch("random", 'r', "random", "Do a random test on at most 1 million strings."), new UnflaggedOption("list", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The filename for the serialised list.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        String listName = jsapResult.getString("list");
        LongList list = (LongList)BinIO.loadObject((CharSequence)listName);
        long total = 0L;
        int n = list.size();
        int k = 13;
        while (k-- != 0) {
            long time = -System.currentTimeMillis();
            for (int i = 0; i < n; ++i) {
                list.getLong(i);
                if (i++ % 100000 != 0) continue;
                System.out.print('.');
            }
            System.out.println();
            time += System.currentTimeMillis();
            if (k < 10) {
                total += time;
            }
            System.out.println((double)time / 1000.0 + "s, " + (double)time * 1000.0 / (double)n + " \u00b5s/item");
        }
        System.out.println("Average: " + Util.format((double)((double)total / 10000.0)) + "s, " + Util.format((double)((double)total * 1000.0 / (double)(10 * n))) + " \u00b5s/item");
    }
}

