/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.sux4j.test;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import com.martiansoftware.jsap.stringparsers.ForNameStringParser;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.objects.Object2LongFunction;
import it.unimi.dsi.io.FastBufferedReader;
import it.unimi.dsi.io.LineIterator;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.zip.GZIPInputStream;

public class HollowTrieSpeedTest {
    public static void main(String[] arg) throws NoSuchMethodException, IOException, JSAPException, ClassNotFoundException {
        SimpleJSAP jsap = new SimpleJSAP(HollowTrieSpeedTest.class.getName(), "Tests the speed of a hollow trie.", new Parameter[]{new FlaggedOption("bufferSize", (StringParser)JSAP.INTSIZE_PARSER, "64Ki", false, 'b', "buffer-size", "The size of the I/O buffer used to read terms."), new FlaggedOption("encoding", (StringParser)ForNameStringParser.getParser(Charset.class), "UTF-8", false, 'e', "encoding", "The term file encoding."), new Switch("zipped", 'z', "zipped", "The term list is compressed in gzip format."), new FlaggedOption("termFile", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'o', "offline", "Read terms from this file (without loading them into core memory) instead of standard input."), new UnflaggedOption("trie", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The filename for the serialised hollow trie.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        int bufferSize = jsapResult.getInt("bufferSize");
        String trieName = jsapResult.getString("trie");
        String termFile = jsapResult.getString("termFile");
        Charset encoding = (Charset)jsapResult.getObject("encoding");
        boolean zipped = jsapResult.getBoolean("zipped");
        Object2LongFunction hollowTrie = (Object2LongFunction)BinIO.loadObject((CharSequence)trieName);
        int k = 10;
        while (k-- != 0) {
            LineIterator i = termFile == null ? new LineIterator(new FastBufferedReader((Reader)new InputStreamReader(System.in, encoding), bufferSize)) : new LineIterator(new FastBufferedReader((Reader)new InputStreamReader(zipped ? new GZIPInputStream(new FileInputStream(termFile)) : new FileInputStream(termFile), encoding), bufferSize));
            long time = -System.currentTimeMillis();
            int j = 0;
            while (i.hasNext()) {
                hollowTrie.getLong(i.next());
                if (j++ % 10000 != 0) continue;
                System.err.print('.');
            }
            System.err.println();
            System.err.println((double)(time += System.currentTimeMillis()) / 1000.0 + "s, " + (double)time * 1000000.0 / (double)j + " ns/vector");
        }
    }
}

