/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.sux4j.test;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.dsi.fastutil.io.FastBufferedOutputStream;
import it.unimi.dsi.logging.ProgressLogger;
import it.unimi.dsi.util.XoRoShiRo128PlusRandomGenerator;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenerateRandom64BitStrings {
    public static final Logger LOGGER = LoggerFactory.getLogger(GenerateRandom64BitStrings.class);

    public static void main(String[] arg) throws JSAPException, IOException {
        SimpleJSAP jsap = new SimpleJSAP(GenerateRandom64BitStrings.class.getName(), "Generates a list of sorted 64-bit random strings using only characters in the ISO-8859-1 printable range [32..256).", new Parameter[]{new FlaggedOption("repeat", (StringParser)JSAP.INTSIZE_PARSER, "1", false, 'r', "repeat", "Repeat each byte this number of times"), new FlaggedOption("gap", (StringParser)JSAP.INTSIZE_PARSER, "1", false, 'g', "gap", "Impose a minimum gap."), new UnflaggedOption("n", (StringParser)JSAP.LONG_PARSER, JSAP.NO_DEFAULT, true, false, "The number of strings (too small values might cause overflow)."), new UnflaggedOption("output", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The output file.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        long n = jsapResult.getLong("n");
        int repeat = jsapResult.getInt("repeat");
        int gap = jsapResult.getInt("gap");
        String output = jsapResult.getString("output");
        XoRoShiRo128PlusRandomGenerator r = new XoRoShiRo128PlusRandomGenerator();
        ProgressLogger pl = new ProgressLogger(LOGGER);
        pl.expectedUpdates = n;
        pl.start((CharSequence)"Generating... ");
        BigInteger l = BigInteger.ZERO;
        BigInteger limit = BigInteger.valueOf(224L).pow(8);
        long incr = (long)Math.floor(1.99 * (double)limit.divide(BigInteger.valueOf(n)).longValue()) - 1L;
        FastBufferedOutputStream fbs = new FastBufferedOutputStream((OutputStream)new FileOutputStream(output));
        BigInteger divisor = BigInteger.valueOf(224L);
        LOGGER.info("Increment: " + incr);
        int[] b = new int[8];
        for (long i = 0L; i < n; ++i) {
            BigInteger t = l = l.add(BigInteger.valueOf((r.nextLong() & Long.MAX_VALUE) % incr + (long)gap));
            if (l.compareTo(limit) >= 0) {
                throw new AssertionError((Object)Long.toString(i));
            }
            int j = 8;
            while (j-- != 0) {
                BigInteger[] a = t.divideAndRemainder(divisor);
                b[j] = a[1].intValue() + 32;
                assert (b[j] < 256);
                assert (b[j] >= 32);
                t = a[0];
            }
            for (j = 0; j < 8; ++j) {
                int k = repeat;
                while (k-- != 0) {
                    fbs.write(b[j]);
                }
            }
            fbs.write(10);
            pl.lightUpdate();
        }
        pl.done();
        fbs.close();
        LOGGER.info("Last/limit: " + l.doubleValue() / limit.doubleValue());
    }
}

