/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.sux4j.test;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.dsi.fastutil.io.FastBufferedOutputStream;
import it.unimi.dsi.logging.ProgressLogger;
import it.unimi.dsi.util.XoRoShiRo128PlusRandomGenerator;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenerateRandom64BitIntegers {
    public static final Logger LOGGER = LoggerFactory.getLogger(GenerateRandom64BitIntegers.class);

    public static void main(String[] arg) throws JSAPException, IOException {
        SimpleJSAP jsap = new SimpleJSAP(GenerateRandom64BitIntegers.class.getName(), "Generates a list of sorted 64-bit random integers in DataOutput format.", new Parameter[]{new FlaggedOption("gap", (StringParser)JSAP.INTSIZE_PARSER, "1", false, 'g', "gap", "Impose a minimum gap."), new UnflaggedOption("n", (StringParser)JSAP.LONG_PARSER, JSAP.NO_DEFAULT, true, false, "The number of integers (too small values might cause overflow)."), new UnflaggedOption("output", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The output file.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        long n = jsapResult.getLong("n");
        int gap = jsapResult.getInt("gap");
        String output = jsapResult.getString("output");
        XoRoShiRo128PlusRandomGenerator r = new XoRoShiRo128PlusRandomGenerator();
        ProgressLogger pl = new ProgressLogger(LOGGER);
        pl.expectedUpdates = n;
        pl.start((CharSequence)"Generating... ");
        BigInteger l = BigInteger.ZERO;
        BigInteger limit = BigInteger.valueOf(256L).pow(8);
        long incr = (long)Math.floor(1.99 * (double)limit.divide(BigInteger.valueOf(n)).longValue()) - 1L;
        DataOutputStream dos = new DataOutputStream((OutputStream)new FastBufferedOutputStream((OutputStream)new FileOutputStream(output)));
        LOGGER.info("Increment: " + incr);
        for (long i = 0L; i < n; ++i) {
            if ((l = l.add(BigInteger.valueOf((r.nextLong() & Long.MAX_VALUE) % incr + (long)gap))).compareTo(limit) > 0) {
                throw new AssertionError((Object)Long.toString(i));
            }
            dos.writeLong(l.longValue());
            pl.lightUpdate();
        }
        pl.done();
        dos.close();
        LOGGER.info("Last/limit: " + l.doubleValue() / limit.doubleValue());
    }
}

