/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.sux4j.test;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.dsi.fastutil.io.FastBufferedOutputStream;
import it.unimi.dsi.logging.ProgressLogger;
import it.unimi.dsi.util.XoRoShiRo128PlusRandomGenerator;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenerateRandom32BitStrings {
    public static final Logger LOGGER = LoggerFactory.getLogger(GenerateRandom32BitStrings.class);

    public static void main(String[] arg) throws JSAPException, IOException {
        SimpleJSAP jsap = new SimpleJSAP(GenerateRandom32BitStrings.class.getName(), "Generates a list of sorted 32-bit random strings using only characters in the ISO-8859-1 printable range [32..256).", new Parameter[]{new FlaggedOption("gap", (StringParser)JSAP.INTSIZE_PARSER, "1", false, 'g', "gap", "Impose a minimum gap."), new UnflaggedOption("n", (StringParser)JSAP.INTEGER_PARSER, JSAP.NO_DEFAULT, true, false, "The number of strings (too small values might cause overflow)."), new UnflaggedOption("output", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The output file.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        int n = jsapResult.getInt("n");
        String output = jsapResult.getString("output");
        int gap = jsapResult.getInt("gap");
        XoRoShiRo128PlusRandomGenerator r = new XoRoShiRo128PlusRandomGenerator();
        ProgressLogger pl = new ProgressLogger(LOGGER);
        pl.expectedUpdates = n;
        pl.start((CharSequence)"Generating... ");
        double l = 0.0;
        double limit = Math.pow(224.0, 4.0);
        int incr = (int)Math.floor(1.99 * (limit / (double)n)) - 1;
        LOGGER.info("Increment: " + incr);
        FastBufferedOutputStream fbs = new FastBufferedOutputStream((OutputStream)new FileOutputStream(output));
        int[] b = new int[4];
        for (int i = 0; i < n; ++i) {
            double t = l += (double)(r.nextInt(incr) + gap);
            if (l >= limit) {
                throw new AssertionError((Object)Integer.toString(i));
            }
            int j = 4;
            while (j-- != 0) {
                b[j] = (int)(t % 224.0 + 32.0);
                t = Math.floor(t / 224.0);
            }
            for (j = 0; j < 4; ++j) {
                fbs.write(b[j]);
            }
            fbs.write(10);
            pl.lightUpdate();
        }
        pl.done();
        fbs.close();
        LOGGER.info("Last/limit: " + l / limit);
    }
}

