/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.sux4j.test;

import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.dsi.fastutil.io.FastBufferedOutputStream;
import it.unimi.dsi.logging.ProgressLogger;
import it.unimi.dsi.util.XoRoShiRo128PlusRandomGenerator;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.math3.distribution.ZipfDistribution;
import org.apache.commons.math3.random.RandomGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneratePowerLawValues {
    public static final Logger LOGGER = LoggerFactory.getLogger(GeneratePowerLawValues.class);

    public static void main(String[] arg) throws JSAPException, IOException {
        SimpleJSAP jsap = new SimpleJSAP(GeneratePowerLawValues.class.getName(), "Generates a binary list of power-law distributed longs starting from zero.", new Parameter[]{new UnflaggedOption("gamma", (StringParser)JSAP.DOUBLE_PARSER, JSAP.NO_DEFAULT, true, false, "The power law exponent."), new UnflaggedOption("max", (StringParser)JSAP.INTEGER_PARSER, JSAP.NO_DEFAULT, true, false, "The strict upper bound for the support of the distribution."), new UnflaggedOption("n", (StringParser)JSAP.LONG_PARSER, JSAP.NO_DEFAULT, true, false, "The number of longs."), new UnflaggedOption("output", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The output file.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        double gamma = jsapResult.getDouble("gamma");
        int max = jsapResult.getInt("max");
        long n = jsapResult.getLong("n");
        String output = jsapResult.getString("output");
        XoRoShiRo128PlusRandomGenerator r = new XoRoShiRo128PlusRandomGenerator();
        ProgressLogger pl = new ProgressLogger(LOGGER);
        pl.expectedUpdates = n;
        pl.start((CharSequence)"Generating... ");
        ZipfDistribution zipf = new ZipfDistribution((RandomGenerator)r, max, gamma);
        DataOutputStream dos = new DataOutputStream((OutputStream)new FastBufferedOutputStream((OutputStream)new FileOutputStream(output)));
        for (long i = 0L; i < n; ++i) {
            dos.writeLong(zipf.sample() - 1);
        }
        pl.done();
        dos.close();
    }
}

